/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.particles.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class FaunaNoteParticle
extends TextureSheetParticle {
    private final double initialX;
    private final double initialZ;
    private double amplitude;
    private double frequency;

    protected FaunaNoteParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.scale(4.0f);
        this.setSize(0.5f, 0.5f);
        this.lifetime = 160;
        this.initialX = x;
        this.initialZ = z;
        this.frequency = 0.1 + (double)(this.random.nextFloat() / 75.0f) * (double)(this.random.nextBoolean() ? -1 : 1);
        this.amplitude = 0.5;
        this.gravity = 3.0E-6f;
        this.xd = xSpeed;
        this.yd = ySpeed + (double)(this.random.nextFloat() / 500.0f);
        this.zd = zSpeed;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        this.amplitude += (double)0.015f;
        if (this.age < this.lifetime && this.alpha >= 0.0f) {
            this.yd -= (double)this.gravity;
            this.move(0.0, this.yd, 0.0);
            this.x = this.initialX + Math.sin((double)this.age * this.frequency) * this.amplitude;
            this.z = this.initialZ + Math.cos((double)this.age * this.frequency) * this.amplitude;
            if (this.age > this.lifetime - 60 && this.alpha > 0.015f) {
                this.alpha -= 0.015f;
            }
        } else {
            this.remove();
        }
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class TrebleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public TrebleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FaunaNoteParticle faunaNoteParticle = new FaunaNoteParticle(level, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
            faunaNoteParticle.pickSprite(this.spriteSet);
            faunaNoteParticle.scale(1.25f);
            return faunaNoteParticle;
        }
    }

    public static class NoteProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public NoteProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FaunaNoteParticle faunaNoteParticle = new FaunaNoteParticle(level, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
            faunaNoteParticle.pickSprite(this.spriteSet);
            return faunaNoteParticle;
        }
    }
}

