/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.screen.custom;

import net.migueel26.faunaandorchestra.block.custom.TipCaseBlock;
import net.migueel26.faunaandorchestra.block.entity.TipCaseBlockEntity;
import net.migueel26.faunaandorchestra.entity.custom.Faust;
import net.migueel26.faunaandorchestra.entity.custom.TalkableEntity;
import net.migueel26.faunaandorchestra.mixins.client.accessors.ClientLevelAccessor;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import oshi.util.tuples.Pair;

public class DialogueScreen {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/dialogue.png");
    public static final int DEFAULT_OFFSET = 80;
    public static final int DEFAULT_BACKGROUND_Y = 160;
    public static final int DEFAULT_BACKGROUND_X = 100;
    public static final int DEFAULT_TEXT_Y = 172;
    public static final int TRANSITION_DURATION = 40;
    public static final int DEFAULT_TEXT_WIDTH = 160;
    public static final double M = 0.5660377358490566;
    public static final double N = -241.69811320754718;
    public static final double My = 0.9760956175298805;
    public static final double Ny = -234.26294820717132;
    protected static int prizeTimer = 0;
    protected static int prize = -1;
    public static final LayeredDraw.Layer OVERLAY = DialogueScreen::renderOverlay;

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker tracker) {
        String currentText;
        String text;
        TalkableEntity entity;
        EntityHitResult entityHitResult;
        Entity hitResultEntity;
        Minecraft minecraft = Minecraft.getInstance();
        HitResult hitResult = minecraft.hitResult;
        if (hitResult instanceof EntityHitResult && (hitResultEntity = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof TalkableEntity && (entity = (TalkableEntity)hitResultEntity).getDialogueTimer() > 0) {
            ResourceLocation icon = entity.getIcon();
            Pair<Integer, Integer> size = entity.getIconSize();
            Pair<Integer, Integer> location = entity.getIconLocation();
            text = entity.getRandomDialogue((Player)minecraft.player);
            int currIconY = (Integer)location.getB() + 80;
            int currBackY = 240;
            int currTextY = 252;
            int currOffset = 80;
            currentText = "";
            guiGraphics.pose().translate(0.0f, 0.0f, 1.0f);
            if (entity.getDialogueTimer() <= 40) {
                currOffset = (int)Math.round(80.0 * (1.0 - Math.pow(1.0 - (double)(entity.getDialogueTimer() - 1) / 40.0, 4.0)));
            }
            if (entity.getDialogueTimer() >= 220 && entity.getDialogueTimer() <= 260) {
                currOffset = (int)Math.round(80.0 * (1.0 - Math.pow((double)(entity.getDialogueTimer() - 220) / 40.0, 4.0)));
            }
            currentText = DialogueScreen.typewritify(text, entity.getDialogueTimer(), guiGraphics, currTextY, currOffset);
            entity.increaseDialogueTimer();
            if (entity.getDialogueTimer() > 260) {
                entity.resetDialogueTimer();
                entity.setGoodMorning(false);
            }
            guiGraphics.blit(BACKGROUND, 100 + DialogueScreen.xOffset(guiGraphics), currBackY - currOffset + DialogueScreen.yOffset(guiGraphics), 0, 0, 223, 40);
            guiGraphics.blit(icon, (Integer)location.getA() + DialogueScreen.xOffset(guiGraphics), currIconY - currOffset + DialogueScreen.yOffset(guiGraphics), 0.0f, 0.0f, ((Integer)size.getA()).intValue(), ((Integer)size.getB()).intValue(), ((Integer)size.getA()).intValue(), ((Integer)size.getB()).intValue());
            guiGraphics.drawWordWrap(minecraft.font, FormattedText.of((String)currentText), 157 + DialogueScreen.xOffset(guiGraphics) + entity.getTextBoxOffset(), currTextY - currOffset + DialogueScreen.yOffset(guiGraphics), 160 - entity.getTextBoxOffset(), 0xFFFFFF);
        }
        if (hitResult instanceof BlockHitResult) {
            TipCaseBlockEntity tipCaseBE;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.getBlockPos();
            BlockState state = minecraft.level.getBlockState(blockPos);
            BlockEntity blockEntity = minecraft.level.getBlockEntity(blockPos);
            if (blockEntity instanceof TipCaseBlockEntity && (tipCaseBE = (TipCaseBlockEntity)blockEntity).getOwner() != null && (text = ((ClientLevelAccessor)minecraft.level).callGetEntities().get(tipCaseBE.getOwner())) instanceof Faust) {
                Faust faust = (Faust)((Object)text);
                int tips = (Integer)state.getValue((Property)TipCaseBlock.TIPS);
                if (tips == 16 && ((Boolean)state.getValue((Property)TipCaseBlock.FIRST)).booleanValue()) {
                    minecraft.level.setBlock(blockPos, (BlockState)state.setValue((Property)TipCaseBlock.FIRST, (Comparable)Boolean.valueOf(false)), 3);
                    prize = 1;
                    prizeTimer = 1;
                } else if (tips == 32 && ((Boolean)state.getValue((Property)TipCaseBlock.SECOND)).booleanValue()) {
                    minecraft.level.setBlock(blockPos, (BlockState)state.setValue((Property)TipCaseBlock.SECOND, (Comparable)Boolean.valueOf(false)), 3);
                    prize = 2;
                    prizeTimer = 1;
                }
                if (tips == 64 && ((Boolean)state.getValue((Property)TipCaseBlock.THIRD)).booleanValue()) {
                    minecraft.level.setBlock(blockPos, (BlockState)state.setValue((Property)TipCaseBlock.THIRD, (Comparable)Boolean.valueOf(false)), 3);
                    prize = 3;
                    prizeTimer = 1;
                }
            }
        }
        if (prizeTimer >= 1) {
            ResourceLocation faust = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/faust_icon.png");
            ResourceLocation orion = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/orion_icon.png");
            Pair size = new Pair((Object)49, (Object)60);
            Pair location = new Pair((Object)107, (Object)136);
            String text2 = Component.translatable((String)("dialogue.faunaandorchestra.ringtails_prize" + prize)).getString();
            int currIconY = (Integer)location.getB() + 80;
            int currBackY = 240;
            int currTextY = 247;
            int currOffset = 80;
            int wordWrapX = 157;
            currentText = "";
            if (prizeTimer <= 40) {
                currOffset = (int)Math.round(80.0 * (1.0 - Math.pow(1.0 - (double)(prizeTimer - 1) / 40.0, 4.0)));
            }
            if (prizeTimer >= 220 && prizeTimer <= 260) {
                currOffset = (int)Math.round(80.0 * (1.0 - Math.pow((double)(prizeTimer - 220) / 40.0, 4.0)));
            }
            currentText = DialogueScreen.typewritify(text2, prizeTimer, guiGraphics, currTextY, currOffset);
            if (++prizeTimer > 260) {
                prizeTimer = 0;
                prize = -1;
            }
            ResourceLocation icon = switch (prize) {
                case 1 -> orion;
                case 2 -> faust;
                default -> orion;
            };
            guiGraphics.blit(BACKGROUND, 100 + DialogueScreen.xOffset(guiGraphics), currBackY - currOffset + DialogueScreen.yOffset(guiGraphics), 0, 0, 223, 40);
            guiGraphics.blit(icon, (Integer)location.getA() + DialogueScreen.xOffset(guiGraphics) - 5, currIconY - currOffset + DialogueScreen.yOffset(guiGraphics), 0.0f, 0.0f, ((Integer)size.getA()).intValue(), ((Integer)size.getB()).intValue(), ((Integer)size.getA()).intValue(), ((Integer)size.getB()).intValue());
            if (prize == 3) {
                guiGraphics.blit(faust, (Integer)location.getA() + DialogueScreen.xOffset(guiGraphics) + 10, currIconY - currOffset + DialogueScreen.yOffset(guiGraphics), 0.0f, 0.0f, ((Integer)size.getA()).intValue(), ((Integer)size.getB()).intValue(), ((Integer)size.getA()).intValue(), ((Integer)size.getB()).intValue());
                wordWrapX += 10;
            }
            guiGraphics.drawWordWrap(minecraft.font, FormattedText.of((String)currentText), wordWrapX + DialogueScreen.xOffset(guiGraphics), currTextY - currOffset + DialogueScreen.yOffset(guiGraphics), 160, 0xFFFFFF);
        }
    }

    private static int xOffset(GuiGraphics guiGraphics) {
        return (int)Math.round(0.5660377358490566 * (double)guiGraphics.guiWidth() + -241.69811320754718);
    }

    private static int yOffset(GuiGraphics guiGraphics) {
        return (int)Math.round(0.9760956175298805 * (double)guiGraphics.guiHeight() + -234.26294820717132);
    }

    private static String typewritify(String fullText, int dialogueTimer, GuiGraphics guiGraphics, int currentTextY, int currentOffset) {
        LocalPlayer player = Minecraft.getInstance().player;
        boolean hasLaugh = false;
        if (fullText.charAt(fullText.length() - 1) == '#') {
            fullText = fullText.substring(0, fullText.length() - 2);
            hasLaugh = true;
        }
        if (hasLaugh && dialogueTimer >= fullText.length() * 2) {
            String laugh = Component.translatable((String)"dialogue.faunaandorchestra.orion_laugh").getString();
            int newTime = dialogueTimer - fullText.length() * 2;
            String drawLaugh = newTime < laugh.length() * 20 ? laugh.substring(0, newTime / 20) : laugh;
            int laughY = (int)Math.round((double)(currentTextY - currentOffset + 9) + Math.sin(newTime / 5) * 3.0);
            if (newTime <= laugh.length() * 20 && newTime % 20 == 0) {
                player.playSound(ModSounds.DIALOGUE.get(), 0.5f, RandomSource.create().nextFloat());
            }
            guiGraphics.drawString(Minecraft.getInstance().font, drawLaugh, 260 + DialogueScreen.xOffset(guiGraphics), laughY + DialogueScreen.yOffset(guiGraphics), 0xFFFFFF);
        }
        if (dialogueTimer <= fullText.length() * 2 && dialogueTimer % 2 == 0) {
            player.playSound(ModSounds.DIALOGUE.get(), 0.5f, RandomSource.create().nextFloat());
        }
        return dialogueTimer < fullText.length() * 2 ? fullText.substring(0, dialogueTimer / 2) : fullText;
    }
}

