/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.migueel26.faunaandorchestra.entity.custom.Faust;
import net.migueel26.faunaandorchestra.entity.custom.Orion;
import net.migueel26.faunaandorchestra.entity.custom.TalkableEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class ModSavedData
extends SavedData {
    public final Map<UUID, List<Entry>> ANIMAL_MAP = new HashMap<UUID, List<Entry>>();

    public static ModSavedData create() {
        return new ModSavedData();
    }

    public static ModSavedData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ModSavedData data = ModSavedData.create();
        ListTag listTag = tag.getList("TalkingEntityList", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            Entry entry = new Entry(listTag.getCompound(i));
            List list = data.ANIMAL_MAP.getOrDefault(entry.playerUUID, new ArrayList());
            if (!list.isEmpty()) {
                ArrayList<Entry> newList = new ArrayList<Entry>(list);
                newList.add(entry);
                data.ANIMAL_MAP.put(entry.playerUUID, newList);
                continue;
            }
            data.ANIMAL_MAP.put(entry.playerUUID, List.of(entry));
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag listTag = new ListTag();
        for (List<Entry> entries : this.ANIMAL_MAP.values()) {
            for (Entry entry : entries) {
                listTag.add((Object)entry.save(new CompoundTag()));
            }
        }
        tag.put("TalkingEntityList", (Tag)listTag);
        return tag;
    }

    public static ModSavedData from(ServerLevel level) {
        return (ModSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(ModSavedData::create, ModSavedData::load), "talking_entity_data");
    }

    public static int getConfidence(ServerLevel level, TalkableEntity entity, UUID player) {
        int confidence = 0;
        Map<UUID, List<Entry>> map = ModSavedData.from((ServerLevel)level).ANIMAL_MAP;
        List entryList = map.getOrDefault(player, null);
        String name = ModSavedData.getTalkableEntityName(entity);
        if (entryList != null && name != null) {
            for (Entry entry : entryList) {
                if (!name.equalsIgnoreCase(entry.talkingEntity)) continue;
                confidence = entry.confidence;
            }
        }
        return confidence;
    }

    public static void saveConfidence(ServerLevel level, TalkableEntity entity, UUID player, int confidence) {
        Map<UUID, List<Entry>> map = ModSavedData.from((ServerLevel)level).ANIMAL_MAP;
        List entryList = map.getOrDefault(player, null);
        String name = ModSavedData.getTalkableEntityName(entity);
        if (name != null) {
            if (entryList == null || entryList.isEmpty()) {
                map.put(player, List.of(new Entry(player, name, confidence)));
            } else {
                boolean found = false;
                for (Entry entry : entryList) {
                    if (!entry.talkingEntity.equalsIgnoreCase(name)) continue;
                    entry.confidence = confidence;
                    found = true;
                }
                if (!found) {
                    ArrayList<Entry> newList = new ArrayList<Entry>(entryList);
                    newList.add(new Entry(player, name, confidence));
                    map.put(player, newList);
                }
            }
            ModSavedData.from(level).setDirty();
        }
    }

    @Nullable
    private static String getTalkableEntityName(TalkableEntity entity) {
        String name = null;
        TalkableEntity talkableEntity = entity;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Faust.class, Orion.class}, (Object)talkableEntity, n)) {
            case 0: {
                Faust faust = (Faust)talkableEntity;
                name = "faust";
                break;
            }
            case 1: {
                Orion orion = (Orion)talkableEntity;
                name = "orion";
                break;
            }
        }
        return name;
    }

    public static class Entry {
        public UUID playerUUID;
        public String talkingEntity;
        public int confidence;

        public Entry(UUID playerUUID, String talkingEntity, int confidence) {
            this.playerUUID = playerUUID;
            this.talkingEntity = talkingEntity;
            this.confidence = confidence;
        }

        public Entry(CompoundTag tag) {
            this(tag.getUUID("player"), tag.getString("animal"), tag.getInt("confidence"));
        }

        public CompoundTag save(CompoundTag tag) {
            tag.putUUID("player", this.playerUUID);
            tag.putString("animal", this.talkingEntity);
            tag.putInt("confidence", this.confidence);
            return tag;
        }
    }
}

