/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PlayerUtil {
    public static <T extends Entity> List<T> entitiesInFrontOf(Entity entity, double range, Level level, Class<T> entityClazz, @Nullable Predicate<? super T> entityFilter) {
        double halfWidth = 1.0;
        double coneAngleDeg = 60.0;
        double minDot = Math.cos(Math.toRadians(coneAngleDeg));
        ArrayList<Entity> targets = new ArrayList<Entity>();
        Vec3 look = entity.getLookAngle().normalize();
        Vec3 pos = entity.position();
        Vec3 end = pos.add(look.scale(range));
        AABB aabb = new AABB(Math.min(pos.x, end.x) - halfWidth, Math.min(pos.y, end.y) - halfWidth, Math.min(pos.z, end.z) - halfWidth, Math.max(pos.x, end.x) + halfWidth, Math.max(pos.y, end.y) + halfWidth, Math.max(pos.z, end.z) + halfWidth);
        Predicate<? super T> filter = entityFilter == null ? t -> true : entityFilter;
        double rangeSq = range * range;
        for (Entity candidate : level.getEntitiesOfClass(entityClazz, aabb, filter)) {
            Vec3 toNorm;
            double dot;
            Vec3 to;
            double distSq;
            if (candidate == entity || (distSq = (to = candidate.position().subtract(pos)).lengthSqr()) > rangeSq || (dot = look.dot(toNorm = to.normalize())) < minDot) continue;
            targets.add(candidate);
        }
        return targets;
    }

    public static void spawnParticlesFromEntityTo(SimpleParticleType particleType, ServerLevel level, Entity startEntity, Entity endEntity, float startOffset, float endOffset) {
        Vec3 start = startEntity.position().add(0.0, (double)(startEntity.getEyeHeight() + startOffset), 0.0);
        Vec3 end = endEntity.position().add(0.0, (double)(endEntity.getBbHeight() / 2.0f + endOffset), 0.0);
        Vec3 dir = end.subtract(start);
        double distance = dir.length();
        dir = dir.normalize();
        for (double i = 0.0; i < distance; i += 0.1) {
            double pOffset = 0.05f;
            Vec3 pos = start.add(dir.scale(i));
            level.sendParticles((ParticleOptions)particleType, pos.x, pos.y, pos.z, 2, pOffset, pOffset, pOffset, (double)0.01f);
        }
    }

    public static void spawnParticlesFromTo(SimpleParticleType particleType, int count, ServerLevel level, Vec3 start, Vec3 end) {
        Vec3 dir = end.subtract(start);
        double distance = dir.length();
        dir = dir.normalize();
        for (double i = 0.0; i < distance; i += 0.1) {
            double pOffset = 0.05f;
            Vec3 pos = start.add(dir.scale(i));
            level.sendParticles((ParticleOptions)particleType, pos.x, pos.y, pos.z, count, pOffset, pOffset, pOffset, (double)0.01f);
        }
    }
}

