/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.entity.MelomancyCauldronBlockEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.potion.ModPotions;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import oshi.util.tuples.Pair;

public class RecipesUtil {
    public static final int NUMBER_RECIPES = 7;
    public static HashSet<ItemStack> MUSICAL_INK = new HashSet<ItemStack>(List.of(new ItemStack((ItemLike)Items.FEATHER, 1), new ItemStack((ItemLike)Items.GLOW_INK_SAC, 1)));
    public static HashSet<ItemStack> OFFERING = new HashSet<ItemStack>(List.of(new ItemStack((ItemLike)Items.ALLIUM, 3), new ItemStack((ItemLike)Items.GLOW_BERRIES, 5), new ItemStack((ItemLike)ModItems.GINKGO_BILOBA.get(), 5), new ItemStack((ItemLike)Items.SWEET_BERRIES, 10)));
    public static HashSet<ItemStack> ABSOLUTE_HEARING_POTION = new HashSet<ItemStack>(List.of(new ItemStack((ItemLike)Items.BLAZE_POWDER, 1), new ItemStack((ItemLike)Items.NETHER_WART, 1), new ItemStack((ItemLike)ModItems.GINKGO_BILOBA.get(), 3)));
    public static HashSet<ItemStack> STEELSONIC = new HashSet<ItemStack>(List.of(new ItemStack((ItemLike)Items.IRON_INGOT, 5), new ItemStack((ItemLike)Items.LAVA_BUCKET, 1), new ItemStack((ItemLike)ModItems.WANDERING_NOTE.get(), 3)));
    public static HashSet<ItemStack> SINGING_SEED = new HashSet<ItemStack>(List.of(new ItemStack((ItemLike)Items.BEETROOT_SEEDS, 3), new ItemStack((ItemLike)Items.HONEYCOMB, 2), new ItemStack((ItemLike)Items.CARROT, 5), new ItemStack((ItemLike)ModItems.WANDERING_NOTE.get(), 3)));
    public static HashSet<ItemStack> BOOGIE_BOMB = new HashSet<ItemStack>(List.of(new ItemStack((ItemLike)Items.GUNPOWDER, 3), new ItemStack((ItemLike)Items.SAND, 2)));
    public static HashSet<ItemStack> AMPLIFIER_CRYSTAL = new HashSet<ItemStack>(List.of(new ItemStack((ItemLike)Items.DIAMOND, 5), new ItemStack((ItemLike)ModItems.WANDERING_NOTE.get(), 3), new ItemStack((ItemLike)ModItems.STEELSONIC_INGOT.get(), 2)));
    public static Map<Item, Pair<Integer, Item>> DISCORD_NUCLEI = Map.of(Items.OXEYE_DAISY, new Pair((Object)50, (Object)ModBlocks.DISCORDED_FLOWER.asItem()), (Item)ModItems.BOOGIE_FRUIT.get(), new Pair((Object)30, (Object)ModItems.DISCORD_BOMB.asItem()), (Item)ModItems.VOICE.get(), new Pair((Object)30, (Object)ModItems.TRANSMUTED_VOICE.asItem()));
    public static Map<Item, Pair<Integer, Float>> UNSTABILITY_INDEXES = Map.of(Items.OXEYE_DAISY, new Pair((Object)15, (Object)Float.valueOf(3.0f)), (Item)ModItems.BOOGIE_FRUIT.get(), new Pair((Object)10, (Object)Float.valueOf(3.5f)), (Item)ModItems.VOICE.get(), new Pair((Object)10, (Object)Float.valueOf(3.5f)));

    public static String isRecipe(NonNullList<ItemStack> ingredients) {
        Object result = "discord";
        block9: for (int i = 1; ((String)result).equalsIgnoreCase("discord") && i <= 7; ++i) {
            switch (i) {
                case 1: {
                    result = RecipesUtil.sameIngredients(ingredients, MUSICAL_INK) ? "musical_ink" : "discord";
                    continue block9;
                }
                case 2: {
                    result = RecipesUtil.sameIngredients(ingredients, OFFERING) ? "offering" : "discord";
                    continue block9;
                }
                case 3: {
                    result = RecipesUtil.sameIngredients(ingredients, ABSOLUTE_HEARING_POTION) ? "absolute_hearing" : "discord";
                    continue block9;
                }
                case 4: {
                    result = RecipesUtil.sameIngredients(ingredients, STEELSONIC) ? "steelsonic" : "discord";
                    continue block9;
                }
                case 5: {
                    result = RecipesUtil.sameIngredients(ingredients, SINGING_SEED) ? "singing_seed" : "discord";
                    continue block9;
                }
                case 6: {
                    result = RecipesUtil.sameIngredients(ingredients, BOOGIE_BOMB) ? "boogie_bomb" : "discord";
                    continue block9;
                }
                case 7: {
                    result = RecipesUtil.sameIngredients(ingredients, AMPLIFIER_CRYSTAL) ? "amplifier_crystal" : "discord";
                }
            }
        }
        if (((String)result).equalsIgnoreCase("discord")) {
            result = "discord:" + ingredients.stream().map(ItemStack::getCount).mapToInt(Integer::intValue).sum() / 2;
        }
        return result;
    }

    public static boolean isCorrectItem(ItemStack stack, MelomancyCauldronBlockEntity cauldronBlock) {
        return stack.is(switch (cauldronBlock.getMixResult()) {
            case "musical_ink", "absolute_hearing" -> Items.GLASS_BOTTLE;
            case "offering" -> Items.STRING;
            case "singing_seed" -> Items.WHEAT_SEEDS;
            case "boogie_bomb" -> (Item)ModItems.BOOGIE_FRUIT.get();
            case "amplifier_crystal" -> Items.AMETHYST_SHARD;
            default -> stack.getItem();
        });
    }

    private static boolean sameIngredients(Collection<ItemStack> ingredients, Collection<ItemStack> recipe) {
        ArrayList<ItemStack> copy2 = new ArrayList<ItemStack>(recipe);
        for (ItemStack item1 : ingredients) {
            boolean found = false;
            for (ItemStack item2 : recipe) {
                if ((!ItemStack.isSameItemSameComponents((ItemStack)item1, (ItemStack)item2) || item1.getCount() != item2.getCount()) && !item1.isEmpty()) continue;
                found = true;
                if (item1.isEmpty()) break;
                copy2.remove(item2);
                break;
            }
            if (found) continue;
            return false;
        }
        return copy2.isEmpty();
    }

    public static ItemStack getMixResult(String mixResult) {
        return switch (mixResult) {
            case "musical_ink" -> new ItemStack((ItemLike)ModItems.MUSICAL_INK.get(), 3);
            case "offering" -> new ItemStack((ItemLike)ModItems.OFFERING.get());
            case "absolute_hearing" -> PotionContents.createItemStack((Item)Items.POTION, ModPotions.ABSOLUTE_HEARING_POTION);
            case "steelsonic" -> new ItemStack((ItemLike)ModItems.STEELSONIC_INGOT.get(), 2);
            case "singing_seed" -> new ItemStack((ItemLike)ModItems.SINGING_SEED.get(), 1);
            case "boogie_bomb" -> new ItemStack((ItemLike)ModItems.BOOGIE_BOMB.get(), 1);
            case "amplifier_crystal" -> new ItemStack((ItemLike)ModItems.AMPLIFIER_CRYSTAL.get(), 1);
            default -> new ItemStack((ItemLike)ModItems.DISCORD_ESSENCE.get(), Integer.parseInt(mixResult.split(":")[1]));
        };
    }

    public static boolean isDiscordNucleiIngredient(ItemStack stack) {
        return DISCORD_NUCLEI.containsKey(stack.getItem());
    }

    public static Pair<Integer, Item> getDiscordNucleiResult(ItemStack stack) {
        return DISCORD_NUCLEI.get(stack.getItem());
    }

    public static Pair<Integer, Float> getDiscordNucleiIndexes(ItemStack stack) {
        return UNSTABILITY_INDEXES.get(stack.getItem());
    }
}

