/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AltarBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<AltarBlock> CODEC = AltarBlock.simpleCodec(AltarBlock::new);
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)4.0, (double)14.5), (VoxelShape[])new VoxelShape[]{Block.box((double)3.75, (double)4.0, (double)3.75, (double)12.25, (double)12.0, (double)12.25), Block.box((double)2.75, (double)12.0, (double)2.75, (double)13.25, (double)16.0, (double)13.25)});

    public AltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    protected float getYRot(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

