/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.AltarBlock;
import net.migueel26.faunaandorchestra.block.custom.VoiceChamberBlock;
import net.migueel26.faunaandorchestra.block.entity.AltarOfThePanFluteBlockEntity;
import net.migueel26.faunaandorchestra.block.entity.VoiceChamberBlockEntity;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.PlayerUtil;
import net.migueel26.faunaandorchestra.util.VesselUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AltarOfThePanFluteBlock
extends AltarBlock
implements EntityBlock {
    public static final int FIRST_THUNDER_TICKS = 10;
    public static final int CONSEQUENT_THUNDERS_TICKS = 80;
    private static final int FINAL_THUNDERS_TICKS = 10;
    protected int song = -1;
    protected int times = 0;
    public static final BooleanProperty PAN_FLUTE = BooleanProperty.create((String)"pan_flute");

    public AltarOfThePanFluteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)PAN_FLUTE, (Comparable)Boolean.valueOf(false)));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (((Boolean)state.getValue((Property)PAN_FLUTE)).booleanValue() && !newState.is(ModBlocks.ALTAR_OF_THE_PAN_FLUTE)) {
            AltarOfThePanFluteBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModItems.PAN_FLUTE.get()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AltarOfThePanFluteBlockEntity) {
            AltarOfThePanFluteBlockEntity altar = (AltarOfThePanFluteBlockEntity)blockEntity;
            if (stack.is(ModItems.PAN_FLUTE) && !((Boolean)state.getValue((Property)PAN_FLUTE)).booleanValue()) {
                altar.setPowers((List)stack.get(ModDataComponents.PAN_FLUTE_LIST));
                player.setItemSlot(hand.equals((Object)InteractionHand.MAIN_HAND) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                level.setBlock(pos, (BlockState)state.setValue((Property)PAN_FLUTE, (Comparable)Boolean.valueOf(true)), 3);
                level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_CLUSTER_PLACE, SoundSource.BLOCKS, 1.0f, 1.5f);
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.isEmpty() && ((Boolean)state.getValue((Property)PAN_FLUTE)).booleanValue() && this.song == -1 && !level.isClientSide()) {
                List<BlockPos> chambers = this.getChambers(pos);
                this.song = this.getNewSong(level, chambers);
                if (this.song != -1) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ModParticleTypes.MAGICAL_NOTE.get(), pos.getCenter().x, (double)((float)pos.getY() + 1.0f), pos.getCenter().z, 20, 0.1, 0.1, 0.1, 0.05);
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSounds.VESSEL_COLLECT.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSounds.PAN_FLUTE_ALTAR_QUAKE.get(), SoundSource.NEUTRAL, 1.25f, 1.0f);
                    for (BlockPos chamberPos : chambers) {
                        BlockEntity blockEntity2 = level.getBlockEntity(chamberPos);
                        if (!(blockEntity2 instanceof VoiceChamberBlockEntity)) continue;
                        VoiceChamberBlockEntity chamberBE = (VoiceChamberBlockEntity)blockEntity2;
                        chamberBE.setLocked(true);
                    }
                    this.times = 0;
                    level.scheduleTick(pos, (Block)this, 10);
                    return ItemInteractionResult.SUCCESS;
                }
                player.setItemInHand(hand, new ItemStack(ModItems.PAN_FLUTE, 1, DataComponentPatch.builder().set((DataComponentType)ModDataComponents.PAN_FLUTE_LIST.get(), altar.getPowers()).build()));
                if (!level.isClientSide()) {
                    if (altar.getPowers().size() == 1) {
                        ((CustomSimpleTrigger)((Object)ModAdvancements.PAN_FLUTE.get())).trigger((ServerPlayer)player);
                    } else if (altar.getPowers().size() == VesselUtil.SOUNDS.size()) {
                        ((CustomSimpleTrigger)((Object)ModAdvancements.PAN_FLUTE_COMPLETE.get())).trigger((ServerPlayer)player);
                    }
                }
                altar.setPowers(List.of());
                level.setBlock(pos, (BlockState)state.setValue((Property)PAN_FLUTE, (Comparable)Boolean.valueOf(false)), 3);
                level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_CLUSTER_PLACE, SoundSource.BLOCKS, 1.0f, 1.5f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.song == this.getNewSong((Level)level, this.getChambers(pos))) {
            if (this.times < 6) {
                List<BlockPos> actualPosChambers = this.getChambers(pos).stream().map(arg_0 -> ((ServerLevel)level).getBlockEntity(arg_0)).filter(be -> be instanceof VoiceChamberBlockEntity).filter(be -> !((VoiceChamberBlockEntity)((Object)be)).getVoice().isEmpty()).map(BlockEntity::getBlockPos).toList();
                for (BlockPos chamberPos : actualPosChambers) {
                    PlayerUtil.spawnParticlesFromTo(ParticleTypes.CLOUD, 1, level, chamberPos.getCenter().add(0.0, 0.25, 0.0), pos.getCenter().add(0.0, 0.85, 0.0));
                }
                if (!level.isClientSide()) {
                    level.sendParticles((ParticleOptions)ModParticleTypes.MAGICAL_NOTE.get(), pos.getCenter().x, (double)((float)pos.getY() + 1.0f), pos.getCenter().z, 20, 0.1, 0.1, 0.1, 0.05);
                }
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSounds.PAN_FLUTE_ALTAR_THUNDER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (this.times >= 3) {
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSounds.VESSEL_COLLECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (this.times >= 3) {
                    level.scheduleTick(pos, (Block)ModBlocks.ALTAR_OF_THE_PAN_FLUTE.get(), 10);
                } else {
                    level.scheduleTick(pos, (Block)ModBlocks.ALTAR_OF_THE_PAN_FLUTE.get(), 80);
                }
            } else {
                Object actualPosChambers = level.getBlockEntity(pos);
                if (actualPosChambers instanceof AltarOfThePanFluteBlockEntity) {
                    ArrayList<Integer> powers;
                    AltarOfThePanFluteBlockEntity altarBE = (AltarOfThePanFluteBlockEntity)((Object)actualPosChambers);
                    actualPosChambers = this.getChambers(pos).stream().map(arg_0 -> ((ServerLevel)level).getBlockEntity(arg_0)).filter(be -> be instanceof VoiceChamberBlockEntity).filter(be -> !((VoiceChamberBlockEntity)((Object)be)).getVoice().isEmpty()).map(BlockEntity::getBlockPos).toList();
                    Iterator<Object> iterator = actualPosChambers.iterator();
                    while (iterator.hasNext()) {
                        BlockPos chamberPos = (BlockPos)iterator.next();
                        PlayerUtil.spawnParticlesFromTo(ParticleTypes.CLOUD, 1, level, chamberPos.getCenter().add(0.0, 0.25, 0.0), pos.getCenter().add(0.0, 0.85, 0.0));
                    }
                    for (BlockPos chamberPos : this.getChambers(pos)) {
                        BlockEntity blockEntity = level.getBlockEntity(chamberPos);
                        if (!(blockEntity instanceof VoiceChamberBlockEntity)) continue;
                        VoiceChamberBlockEntity be2 = (VoiceChamberBlockEntity)blockEntity;
                        be2.setLocked(false);
                        be2.setVoice("");
                        level.setBlock(chamberPos, (BlockState)level.getBlockState(chamberPos).setValue((Property)VoiceChamberBlock.VOICE, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    EntityType.LIGHTNING_BOLT.spawn(level, pos, MobSpawnType.MOB_SUMMONED);
                    SoundEvent soundEvent = switch (this.song) {
                        case 1 -> ModSounds.PAN_FLUTE_NOTES.get();
                        case 2 -> ModSounds.PAN_FLUTE_PUSH.get();
                        case 3 -> ModSounds.PAN_FLUTE_HEALTH.get();
                        case 4 -> ModSounds.PAN_FLUTE_WIND.get();
                        case 5 -> ModSounds.PAN_FLUTE_NATURE.get();
                        default -> ModSounds.PAN_FLUTE_USE.get();
                    };
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (!level.isClientSide()) {
                        level.sendParticles((ParticleOptions)ParticleTypes.FLAME, pos.getCenter().x, (double)pos.getY() + 1.0, pos.getCenter().z, 180, (double)0.1f, (double)0.1f, (double)0.1f, 0.25);
                    }
                    if (!(powers = new ArrayList<Integer>(altarBE.getPowers())).contains(this.song)) {
                        powers.add(this.song);
                    }
                    altarBE.setPowers(powers);
                    this.song = -1;
                    this.times = 0;
                }
            }
            ++this.times;
        } else {
            List<BlockPos> chambers = this.getChambers(pos);
            this.song = this.getNewSong((Level)level, chambers);
            for (BlockPos chamber : chambers) {
                BlockEntity blockEntity = level.getBlockEntity(chamber);
                if (!(blockEntity instanceof VoiceChamberBlockEntity)) continue;
                VoiceChamberBlockEntity be3 = (VoiceChamberBlockEntity)blockEntity;
                be3.setLocked(false);
            }
        }
        super.tick(state, level, pos, random);
    }

    private int getNewSong(Level level, List<BlockPos> chambersPos) {
        int sound = -1;
        List<EntityType> voicesList = chambersPos.stream().map(arg_0 -> ((Level)level).getBlockEntity(arg_0)).filter(be -> be instanceof VoiceChamberBlockEntity).filter(be -> !((VoiceChamberBlockEntity)((Object)be)).getVoice().isEmpty()).map(be -> (EntityType)EntityType.byString((String)((VoiceChamberBlockEntity)((Object)be)).getVoice()).get()).toList();
        if (!voicesList.isEmpty()) {
            Map<? extends EntityType<?>, Integer> voicesMap = this.voicesAsMap(voicesList);
            for (Map.Entry<Map<EntityType<?>, Integer>, Integer> entry : VesselUtil.SOUNDS.entrySet()) {
                if (!entry.getKey().equals(voicesMap)) continue;
                sound = entry.getValue();
                break;
            }
        }
        return sound;
    }

    private Map<? extends EntityType<?>, Integer> voicesAsMap(List<? extends EntityType<?>> list) {
        HashMap map = new HashMap();
        for (EntityType<?> entityType : list) {
            if (!map.containsKey(entityType)) {
                map.put(entityType, 1);
                continue;
            }
            map.put(entityType, (Integer)map.get(entityType) + 1);
        }
        return map;
    }

    private List<BlockPos> getChambers(BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        return List.of(new BlockPos(x + 1, y + 1, z + 3), new BlockPos(x + 3, y + 1, z + 1), new BlockPos(x - 1, y + 1, z + 3), new BlockPos(x - 3, y + 1, z + 1), new BlockPos(x + 1, y + 1, z - 3), new BlockPos(x + 3, y + 1, z - 1), new BlockPos(x - 1, y + 1, z - 3), new BlockPos(x - 3, y + 1, z - 1));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PAN_FLUTE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AltarOfThePanFluteBlockEntity(pos, state);
    }
}

