/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.FlowerGrowerDiscordBlock;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DiscordedFlowerBlock
extends Block {
    protected final Map<Item, Integer> FOOD = Map.ofEntries(Map.entry(Items.ROTTEN_FLESH, 1), Map.entry(Items.BONE, 1), Map.entry(Items.SPIDER_EYE, 2), Map.entry(Items.NETHER_WART, 2), Map.entry(Items.PORKCHOP, 2), Map.entry(Items.CHICKEN, 2), Map.entry(Items.RABBIT, 2), Map.entry(Items.BEEF, 2), Map.entry(Items.SUSPICIOUS_STEW, 3), Map.entry(Items.LEATHER, 3), Map.entry(Items.ARMADILLO_SCUTE, 5), Map.entry(Items.RABBIT_FOOT, 5), Map.entry(Items.TURTLE_SCUTE, 10), Map.entry(Items.SLIME_BALL, 10), Map.entry(Items.MAGMA_CREAM, 10), Map.entry(Items.GHAST_TEAR, 30), Map.entry(Items.PHANTOM_MEMBRANE, 40), Map.entry(Items.NAUTILUS_SHELL, 40), Map.entry(Items.OMINOUS_BOTTLE, 40), Map.entry(Items.ECHO_SHARD, 100), Map.entry(Items.NETHER_STAR, 150));
    protected final Map<Integer, Integer> NEW_GENERATIONS = Map.ofEntries(Map.entry(5, 3), Map.entry(40, 4), Map.entry(80, 5), Map.entry(120, 8), Map.entry(160, 10), Map.entry(200, 13), Map.entry(240, 18), Map.entry(280, 23), Map.entry(320, 28), Map.entry(360, 34), Map.entry(400, 45));
    protected final List<Integer> GENERATIONS_INDEX = new ArrayList<Integer>(List.of(5, 40, 80, 120, 160, 200, 240, 280, 320, 360, 400));
    public static final IntegerProperty HUNGER = IntegerProperty.create((String)"hunger", (int)0, (int)400);
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public DiscordedFlowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HUNGER, (Comparable)Integer.valueOf(0)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int food = this.FOOD.getOrDefault(stack.getItem(), -1);
        if (food != -1) {
            stack.consume(1, (LivingEntity)player);
            level.playSound(player, pos, ModSounds.DISCORDED_FLOWER_EAT.get(), SoundSource.BLOCKS, 0.5f, 1.0f + (level.random.nextFloat() - 0.5f));
            if (!level.isClientSide()) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, 10, 0.25, 0.25, 0.25, 0.05);
            }
            this.feed(state, level, pos, food);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private void feed(BlockState state, Level level, BlockPos pos, int food) {
        int hunger = (Integer)state.getValue((Property)HUNGER);
        int newHunger = hunger + food;
        if (newHunger >= 400 || hunger >= 400) {
            level.setBlock(pos.below(), (BlockState)((Block)ModBlocks.FLOWER_DISCORD_BLOCK.get()).defaultBlockState().setValue((Property)FlowerGrowerDiscordBlock.MAX_GENERATION, (Comparable)this.NEW_GENERATIONS.get(400)), 3);
            if (!level.isClientSide()) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, 80, 0.5, 0.5, 0.5, 0.3);
            }
            level.playSound(null, pos, SoundEvents.WARDEN_EMERGE, SoundSource.NEUTRAL);
            DiscordedFlowerBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModItems.PETALS_OF_DEATH.get()));
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        } else {
            int goal = this.GENERATIONS_INDEX.getFirst();
            for (int i = 0; i < this.NEW_GENERATIONS.keySet().size() && goal == this.GENERATIONS_INDEX.getFirst(); ++i) {
                if (this.GENERATIONS_INDEX.get(i) > hunger || hunger >= this.GENERATIONS_INDEX.get(i + 1)) continue;
                goal = this.GENERATIONS_INDEX.get(i + 1);
            }
            if (newHunger >= goal) {
                int lastGoal = this.GENERATIONS_INDEX.getFirst();
                for (int i = 0; i < this.NEW_GENERATIONS.keySet().size() && lastGoal == this.GENERATIONS_INDEX.getFirst(); ++i) {
                    if (this.GENERATIONS_INDEX.get(i) >= newHunger || newHunger > this.GENERATIONS_INDEX.get(i + 1)) continue;
                    lastGoal = this.GENERATIONS_INDEX.get(i);
                }
                level.setBlock(pos.below(), (BlockState)((Block)ModBlocks.FLOWER_DISCORD_BLOCK.get()).defaultBlockState().setValue((Property)FlowerGrowerDiscordBlock.MAX_GENERATION, (Comparable)this.NEW_GENERATIONS.get(lastGoal)), 3);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)HUNGER, (Comparable)Integer.valueOf(newHunger)), 3);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState belowBlockState = level.getBlockState(blockpos);
        return belowBlockState.is(ModBlocks.DISCORD_BLOCK) || belowBlockState.is(ModBlocks.FLOWER_DISCORD_BLOCK);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, 5, 0.3, 0.3, 0.3, 0.0);
        super.randomTick(state, level, pos, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HUNGER});
    }
}

