/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.ComposerGravestoneBlock;
import net.migueel26.faunaandorchestra.block.entity.ComposerGravestoneBlockEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegularGravestoneBlock
extends ComposerGravestoneBlock {
    public static BooleanProperty CAN_DROP = BooleanProperty.create((String)"can_drop");

    public RegularGravestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CAN_DROP, (Comparable)Boolean.valueOf(true))).setValue((Property)PART, (Comparable)BedPart.FOOT)).setValue((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == RegularGravestoneBlock.getNeighbourDirection((BedPart)state.getValue((Property)PART), (Direction)state.getValue((Property)FACING))) {
            if (neighborState.is((Block)this) && neighborState.getValue((Property)PART) != state.getValue((Property)PART)) {
                return (BlockState)((BlockState)state.setValue((Property)OPENED, (Comparable)((Boolean)neighborState.getValue((Property)OPENED)))).setValue((Property)CAN_DROP, (Comparable)((Boolean)neighborState.getValue((Property)CAN_DROP)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            BlockPos blockPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            boolean canDrop = !(placer instanceof Player);
            level.setBlock(blockPos, (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)BedPart.HEAD)).setValue((Property)CAN_DROP, (Comparable)Boolean.valueOf(canDrop)), 3);
            level.setBlock(pos, (BlockState)state.setValue((Property)CAN_DROP, (Comparable)Boolean.valueOf(canDrop)), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ComposerGravestoneBlockEntity) {
            Vec3 center;
            Vec3 vecPos;
            ComposerGravestoneBlockEntity composerGravestoneBlockEntity = (ComposerGravestoneBlockEntity)blockEntity;
            BlockPos neighbourPos = pos.relative((Direction)state.getValue((Property)FACING));
            if (state.getValue((Property)PART) == BedPart.HEAD) {
                vecPos = neighbourPos.getBottomCenter();
                composerGravestoneBlockEntity = (ComposerGravestoneBlockEntity)level.getBlockEntity(neighbourPos);
            } else {
                vecPos = pos.getBottomCenter();
            }
            int diffX = neighbourPos.getX() - pos.getX();
            int diffZ = neighbourPos.getZ() - pos.getZ();
            double xOffset = 0.25;
            double zOffset = 0.25;
            if (diffX > 0) {
                center = vecPos.subtract(0.5, 0.0, 0.0);
                xOffset = 0.4;
            } else if (diffX < 0) {
                center = vecPos.add(0.5, 0.0, 0.0);
                xOffset = 0.4;
            } else if (diffZ > 0) {
                center = vecPos.subtract(0.0, 0.0, 0.5);
                zOffset = 0.4;
            } else {
                center = vecPos.add(0.0, 0.0, 0.5);
                zOffset = 0.4;
            }
            boolean isOpened = (Boolean)state.getValue((Property)OPENED);
            boolean canDrop = (Boolean)state.getValue((Property)CAN_DROP);
            if (isOpened) {
                composerGravestoneBlockEntity.close();
            } else {
                composerGravestoneBlockEntity.open();
            }
            level.playLocalSound(pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 0.5f, false);
            if (!level.isClientSide() && !isOpened) {
                ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.STONE.defaultBlockState()), center.x, center.y + 0.5, center.z, 20, xOffset, 0.0, zOffset, 1.0);
                if (canDrop) {
                    this.spawnRandomLoot(level, pos);
                }
            }
            if (!isOpened && canDrop) {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)OPENED, (Comparable)Boolean.valueOf(true))).setValue((Property)CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPENED, (Comparable)Boolean.valueOf(!isOpened)), 3);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    private void spawnRandomLoot(Level level, BlockPos pos) {
        float probability = level.getRandom().nextFloat();
        if (probability >= 0.0f && (double)probability <= 0.2) {
            ArrayList<Item> list = new ArrayList<Item>(List.of((Item)ModItems.FLUTE.get(), (Item)ModItems.SAXOPHONE.get(), (Item)ModItems.KEYTAR.get(), (Item)ModItems.OBOE.get(), (Item)ModItems.BATON.get()));
            Item instrument = (Item)list.get(new Random().nextInt(list.size()));
            Skeleton skeleton = (Skeleton)EntityType.SKELETON.spawn((ServerLevel)level, pos, MobSpawnType.MOB_SUMMONED);
            ItemStack item = new ItemStack((ItemLike)instrument);
            item.setDamageValue(10);
            skeleton.setItemSlot(EquipmentSlot.MAINHAND, item);
        } else if ((double)probability > 0.2 && (double)probability <= 0.8) {
            float itemProb = level.getRandom().nextFloat();
            ItemStack reward = itemProb >= 0.0f && (double)itemProb <= 0.05 ? new ItemStack(ModBlocks.GINGKO_BILOBA_SAPLING) : ((double)itemProb > 0.05 && (double)itemProb <= 0.1 ? new ItemStack((ItemLike)Items.DIAMOND, 2) : ((double)itemProb > 0.1 && (double)itemProb <= 0.15 ? new ItemStack((ItemLike)Items.EMERALD, 3) : ((double)itemProb > 0.15 && (double)itemProb <= 0.2 ? new ItemStack((ItemLike)Items.IRON_HORSE_ARMOR) : ((double)itemProb > 0.2 && (double)itemProb <= 0.25 ? new ItemStack((ItemLike)ModItems.BATON.get()) : ((double)itemProb > 0.25 && (double)itemProb < 0.3 ? new ItemStack((ItemLike)Items.IRON_HELMET) : ((double)itemProb >= 0.3 && (double)itemProb < 0.9 ? new ItemStack((ItemLike)Items.BONE, level.getRandom().nextInt(1, 5)) : ItemStack.EMPTY))))));
            RegularGravestoneBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)reward);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, OPENED, CAN_DROP});
    }
}

