/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.entity;

import net.migueel26.faunaandorchestra.block.ModBlockEntities;
import net.migueel26.faunaandorchestra.block.custom.MelomancyCauldronBlock;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.migueel26.faunaandorchestra.util.RecipesUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MelomancyCauldronBlockEntity
extends BlockEntity
implements GeoBlockEntity,
Clearable {
    public static final int NUM_SLOTS = 4;
    public static final int DEFAULT_COOK_TIME = 1800;
    private final NonNullList<ItemStack> ingredients = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected int cookTime = -1;
    protected String mixResult = "null";
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation PREPARING = RawAnimation.begin().thenLoop("preparing");
    private static final RawAnimation MIX = RawAnimation.begin().thenPlay("mix");
    public static final RawAnimation EMPTY = RawAnimation.begin().thenPlay("empty");
    private final AnimationController<MelomancyCauldronBlockEntity> controller = new AnimationController((GeoAnimatable)this, "melomancy_cauldron_controller", 5, this::animController).triggerableAnim("mix", MIX).triggerableAnim("empty", EMPTY);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MelomancyCauldronBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.MELOMANCY_CAULDRON_BE.get(), pos, blockState);
    }

    protected <E extends MelomancyCauldronBlockEntity> PlayState animController(AnimationState<E> state) {
        if (this.isCooking()) {
            state.getController().setAnimation(PREPARING);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public boolean addIngredient(Player player, ItemStack originalStack) {
        boolean found = false;
        for (int i = 0; i < this.ingredients.size() && !found; ++i) {
            ItemStack itemStack = (ItemStack)this.ingredients.get(i);
            if (itemStack.is(originalStack.getItem())) {
                itemStack.setCount(itemStack.getCount() + 1);
                this.ingredients.set(i, (Object)itemStack);
                if (originalStack.is(Items.LAVA_BUCKET) || originalStack.is(Items.WATER_BUCKET) || originalStack.is(Items.POWDER_SNOW_BUCKET)) {
                    player.addItem(new ItemStack((ItemLike)Items.BUCKET));
                }
                originalStack.consume(1, (LivingEntity)player);
                found = true;
                this.triggerAnim("melomancy_cauldron_controller", "mix");
                this.markUpdated();
                continue;
            }
            if (!itemStack.isEmpty()) continue;
            this.ingredients.set(i, (Object)originalStack.consumeAndReturn(1, (LivingEntity)player));
            found = true;
            this.triggerAnim("melomancy_cauldron_controller", "mix");
            this.markUpdated();
        }
        return found;
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, MelomancyCauldronBlockEntity blockEntity) {
        boolean flag = false;
        ItemStack itemstack = (ItemStack)blockEntity.ingredients.get(0);
        if (!itemstack.isEmpty() && blockEntity.cookTime > 0) {
            flag = true;
            --blockEntity.cookTime;
            if (blockEntity.cookTime == 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MelomancyCauldronBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 0.5f);
                blockEntity.mixResult = RecipesUtil.isRecipe(blockEntity.ingredients);
            }
        }
        if (flag) {
            MelomancyCauldronBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, MelomancyCauldronBlockEntity blockEntity) {
        if (level.getRandom().nextFloat() < 0.11f && ((Boolean)state.getValue((Property)MelomancyCauldronBlock.COOKING)).booleanValue()) {
            CampfireBlock.makeParticles((Level)level, (BlockPos)pos, ((Boolean)state.getValue((Property)MelomancyCauldronBlock.COOKING) == false ? 1 : 0) != 0, (boolean)true);
        }
        if ((Integer)state.getValue((Property)MelomancyCauldronBlock.LIQUID) >= 2 && level.getRandom().nextFloat() < 0.11f) {
            double randomX = level.random.nextDouble() / 2.0 - 0.25;
            double randomZ = level.random.nextDouble() / 2.0 - 0.25;
            double randomY = level.random.nextDouble() / 4.0;
            SimpleParticleType particle = blockEntity.mixResult.equalsIgnoreCase("discord") ? ParticleTypes.SCULK_CHARGE_POP : ModParticleTypes.CAULDRON_POP.get();
            level.addParticle((ParticleOptions)particle, pos.getCenter().x + randomX, (double)((float)pos.getY() + 0.65f) + randomY, pos.getCenter().z + randomZ, 0.0, 0.1, 0.0);
        }
    }

    public ItemStack getResult() {
        if (this.cookTime == 0) {
            return RecipesUtil.getMixResult(this.mixResult);
        }
        return ItemStack.EMPTY;
    }

    public boolean cook() {
        if (!((ItemStack)this.ingredients.getFirst()).isEmpty() && !this.isCooking()) {
            this.cookTime = 1800;
            return true;
        }
        return false;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean isCooking() {
        return (Boolean)this.getBlockState().getValue((Property)MelomancyCauldronBlock.COOKING);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.ingredients, (HolderLookup.Provider)registries);
        if (tag.contains("CookTime")) {
            this.cookTime = tag.getInt("CookTime");
        }
        if (tag.contains("MixResult")) {
            this.mixResult = tag.getString("MixResult");
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.ingredients, (boolean)true, (HolderLookup.Provider)registries);
        tag.putInt("CookTime", this.cookTime);
        tag.putString("MixResult", this.mixResult);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compoundTag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.ingredients, (boolean)true, (HolderLookup.Provider)registries);
        compoundTag.putInt("CookTime", this.cookTime);
        compoundTag.putString("MixResult", this.mixResult);
        return compoundTag;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getIngredients());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getIngredients()));
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public String getMixResult() {
        return this.mixResult;
    }

    public NonNullList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public boolean hasFinishedCooking() {
        return this.cookTime == 0;
    }

    public void clearContent(boolean animate) {
        if (animate) {
            this.triggerAnim("melomancy_cauldron_controller", "empty");
        }
        this.ingredients.clear();
        this.cookTime = -1;
        this.mixResult = "null";
        this.setChanged();
    }

    public void clearContent() {
        this.clearContent(true);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

