/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom.decorative;

import java.util.List;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class HealthFluteEntity
extends Bat {
    protected int tick = 0;

    public HealthFluteEntity(EntityType<? extends Bat> entityType, Level level) {
        super(entityType, level);
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void tick() {
        if (!this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX(), this.getY(), this.getZ(), 5, 0.2, 0.2, 0.2, 0.05);
        }
        if (this.tick == 70) {
            this.level().playSound(null, this.blockPosition(), ModSounds.MAGIC_GROWTH.get(), SoundSource.NEUTRAL, 0.6f, 1.0f);
            AABB aabb = this.getBoundingBox().inflate(8.0);
            List players = this.level().getEntitiesOfClass(Player.class, aabb);
            for (Player player : players) {
                if (player.hasEffect(MobEffects.REGENERATION)) continue;
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
            }
            if (!this.level().isClientSide()) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCRAPE, this.getX(), this.getY(), this.getZ(), 40, 3.0, 3.0, 3.0, 0.05);
            }
            this.discard();
        }
        ++this.tick;
        super.tick();
    }

    public boolean isSilent() {
        return true;
    }
}

