/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.networking.RestartOrchestraMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.StopOrchestraMusicS2CPayload;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConductorEntityConductingOrchestraGoal
extends Goal {
    private final ConductorEntity conductor;
    private List<Player> playersListening;
    private int lookCooldown;
    private int waitForMoreMusicians;
    private int currentOrchestraSize;

    public ConductorEntityConductingOrchestraGoal(ConductorEntity conductor) {
        this.conductor = conductor;
    }

    public boolean canUse() {
        return !this.conductor.isOrchestraEmpty() && !this.conductor.isDeadOrDying() && this.conductor.isHoldingBaton();
    }

    public boolean canContinueToUse() {
        return !this.conductor.isOrchestraEmpty() && !this.conductor.isDeadOrDying() && this.conductor.isHoldingBaton();
    }

    public void start() {
        MusicUtil.addNewOrchestra(this.conductor.getUUID(), this.conductor.getSheetMusic());
        this.lookCooldown = 0;
        this.playersListening = this.conductor.level().getEntitiesOfClass(Player.class, this.conductor.getBoundingBox().inflate(50.0, 50.0, 50.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        this.currentOrchestraSize = this.conductor.getOrchestra().size();
        this.waitForMoreMusicians = this.conductor.isReady() ? 140 : -1;
        super.start();
    }

    public void stop() {
        MusicUtil.deleteOrchestra(this.conductor.getUUID());
        this.conductor.level().levelEvent(null, 1011, this.conductor.blockPosition(), 0);
        super.stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        List nearbyPlayers;
        this.conductor.getNavigation().stop();
        if (this.lookCooldown <= 0) {
            this.conductor.getLookControl().setLookAt(this.getCentroid());
            this.lookCooldown = 20;
        } else {
            --this.lookCooldown;
        }
        if (this.waitForMoreMusicians > 0) {
            if (this.currentOrchestraSize != this.conductor.getOrchestra().size()) {
                this.waitForMoreMusicians = 140;
                this.currentOrchestraSize = this.conductor.getOrchestra().size();
            } else {
                --this.waitForMoreMusicians;
            }
        }
        if (this.waitForMoreMusicians == 0 || this.conductor.getTicksPlaying() == MusicUtil.getDuration(this.conductor.getSheetMusic())) {
            this.conductor.setReady(false);
            this.waitForMoreMusicians = -1;
            if (this.conductor.isOrchestraFull()) {
                ((CustomSimpleTrigger)((Object)ModAdvancements.FULL_ORCHESTRA.get())).trigger((ServerPlayer)this.conductor.getOwner());
            }
            nearbyPlayers = this.conductor.level().getEntitiesOfClass(Player.class, this.conductor.getBoundingBox().inflate(32.0, 32.0, 32.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE);
            this.conductor.setTicksPlaying(0);
            int data = this.conductor.level().registryAccess().registryOrThrow(ModItems.ITEMS.getRegistryKey()).getId((Object)this.conductor.getSheetMusic());
            this.conductor.level().levelEvent(null, 4005, this.conductor.blockPosition(), data);
            for (Player player : nearbyPlayers) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new RestartOrchestraMusicS2CPayload(this.conductor.getUUID(), this.conductor.getOrchestra().stream().map(Entity::getUUID).toList(), this.conductor.getTicksPlaying(), this.conductor.getCurrentVolume(), this.conductor.getSheetMusic().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        nearbyPlayers = this.conductor.level().getEntitiesOfClass(Player.class, this.conductor.getBoundingBox().inflate(32.0, 32.0, 32.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        ArrayList newPlayers = new ArrayList(nearbyPlayers);
        ArrayList<Player> exitPlayers = new ArrayList<Player>(this.playersListening);
        exitPlayers.removeAll(nearbyPlayers);
        newPlayers.removeAll(this.playersListening);
        for (Player player : newPlayers) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new RestartOrchestraMusicS2CPayload(this.conductor.getUUID(), this.conductor.getOrchestra().stream().map(Entity::getUUID).toList(), this.conductor.getTicksPlaying(), this.conductor.getCurrentVolume(), this.conductor.getSheetMusic().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        for (Player player : exitPlayers) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new StopOrchestraMusicS2CPayload(this.conductor.getOrchestra().stream().map(Entity::getUUID).toList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.playersListening = nearbyPlayers;
    }

    private Vec3 getCentroid() {
        if (!this.conductor.getOrchestra().isEmpty()) {
            Set<MusicalEntity> orchestra = this.conductor.getOrchestra();
            double n = orchestra.size();
            return new Vec3(orchestra.stream().map(Entity::getX).reduce(0.0, Double::sum) / n, this.conductor.getY(), orchestra.stream().map(Entity::getZ).reduce(0.0, Double::sum) / n);
        }
        return new Vec3(0.0, 0.0, 0.0);
    }
}

