/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import java.util.EnumSet;
import java.util.Optional;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.networking.StartOrchestraMusicS2CPayload;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.PacketDistributor;

public class MusicalEntityPlayingInstrumentGoal
extends Goal {
    private final MusicalEntity musician;
    private ConductorEntity conductor;

    public MusicalEntityPlayingInstrumentGoal(MusicalEntity musician) {
        this.musician = musician;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.musician.getTicksSinceLoaded() <= 20) {
            return false;
        }
        Optional<ConductorEntity> potentialConductor = this.musician.level().getEntitiesOfClass(ConductorEntity.class, this.musician.getBoundingBox().inflate(7.0)).stream().filter(ConductorEntity::isHoldingBaton).filter(ConductorEntity::isHoldingASheetMusic).filter(cond -> cond.isMusicianApt(this.musician)).filter(cond -> cond.getOrchestra().stream().noneMatch(((Object)((Object)this.musician)).getClass()::isInstance)).findAny();
        if (!this.musician.isHoldingInstrument()) {
            return false;
        }
        potentialConductor.ifPresent(this.musician::setConductor);
        if (this.musician.getConductor() != null && this.musician.getConductor().isOrchestraFull()) {
            this.musician.setConductor(null);
            return false;
        }
        return !this.musician.isDeadOrDying() && this.musician.isHoldingInstrument() && potentialConductor.isPresent();
    }

    public boolean canContinueToUse() {
        return this.musician.isHoldingInstrument() && this.conductor != null && this.conductor.isAlive() && this.conductor.isHoldingBaton() && this.musician.distanceTo((Entity)this.conductor) <= 10.0f && this.conductor.isHoldingASheetMusic();
    }

    public void start() {
        this.conductor = this.musician.getConductor();
        this.conductor.addMusician(this.musician);
        int ticksOffset = this.conductor.getTicksPlaying();
        if (!this.conductor.isReady()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new StartOrchestraMusicS2CPayload(this.musician.getUUID(), ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)MusicUtil.getLocation(this.conductor.getSheetMusic(), (Item)this.musician.getInstrument().get())), ticksOffset), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.conductor.isOrchestraFull()) {
            ((CustomSimpleTrigger)((Object)ModAdvancements.FULL_ORCHESTRA.get())).trigger((ServerPlayer)this.conductor.getOwner());
            int data = this.conductor.level().registryAccess().registryOrThrow(ModItems.ITEMS.getRegistryKey()).getId((Object)this.conductor.getSheetMusic());
            this.conductor.level().levelEvent(null, 4005, this.conductor.blockPosition(), data);
        }
    }

    public void stop() {
        if (this.conductor != null) {
            this.conductor.removeMusician(this.musician);
        }
        if (this.conductor.isOrchestraEmpty()) {
            this.conductor.setTicksPlaying(0);
        }
        this.musician.setConductor(null);
        this.conductor = null;
    }

    public void tick() {
        this.musician.getNavigation().stop();
        this.musician.getLookControl().setLookAt((Entity)this.conductor);
    }
}

