/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.migueel26.faunaandorchestra.entity.custom.QuirkyFrogEntity;
import net.migueel26.faunaandorchestra.networking.StartAmbientMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.StopMusicS2CPayload;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class QuirkyFrogConductingChoirGoal
extends Goal {
    private QuirkyFrogEntity conductor;
    private boolean startSinging;
    private int tick;
    private int times;
    private LinkedList<QuirkyFrogEntity> choir;

    public QuirkyFrogConductingChoirGoal(QuirkyFrogEntity quirkyFrog) {
        this.conductor = quirkyFrog;
    }

    public boolean canUse() {
        return !this.conductor.isTame() && this.conductor.isReady() && !this.conductor.isSinging() && this.conductor.getFrogConductor() == null && !this.conductor.isDeadOrDying() && !this.conductor.getFrogChoir().isEmpty();
    }

    public boolean canContinueToUse() {
        return !this.conductor.isDeadOrDying() && !this.conductor.isTame() && this.conductor.getFrogChoir().size() == 4 && this.conductor.isInSittingPose();
    }

    public void start() {
        this.startSinging = false;
        this.conductor.setInSittingPose(true);
        this.tick = 50;
        for (QuirkyFrogEntity chorister : this.conductor.getFrogChoir()) {
            chorister.setFrogConductor(this.conductor);
        }
        this.times = 0;
        this.choir = new LinkedList<QuirkyFrogEntity>(this.conductor.getFrogChoir());
    }

    public void stop() {
        for (QuirkyFrogEntity chorister : this.conductor.getFrogChoir()) {
            chorister.setSinging(false);
            chorister.setFrogConductor(null);
            chorister.setReady(false);
            Vec3 vec3 = this.getPosition();
            if (vec3 == null) continue;
            chorister.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, (double)this.conductor.getSpeed());
        }
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new StopMusicS2CPayload(this.conductor.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.startSinging = false;
        this.conductor.setInSittingPose(false);
        this.conductor.setMusical(false);
        this.conductor.setReady(false);
        this.conductor.setConducting(false);
        this.conductor.setFrogChoir(Collections.emptyList());
        Vec3 vec3 = this.getPosition();
        if (vec3 != null) {
            this.conductor.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, (double)this.conductor.getSpeed());
        }
        super.stop();
    }

    public boolean requiresUpdateEveryTick() {
        return super.requiresUpdateEveryTick();
    }

    public void tick() {
        if (!this.startSinging) {
            if (this.tick == 0) {
                boolean allReady = true;
                Iterator<QuirkyFrogEntity> iterator = this.conductor.getFrogChoir().iterator();
                while (allReady && iterator.hasNext()) {
                    allReady = allReady && iterator.next().isReady();
                }
                if (allReady) {
                    this.startSinging = true;
                    this.tick = 0;
                } else {
                    this.tick = 50;
                }
            } else {
                --this.tick;
            }
        } else {
            if (!this.conductor.isConducting()) {
                this.conductor.setConducting(true);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new StartAmbientMusicS2CPayload(this.conductor.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.conductor.setMusical(true);
            } else {
                this.croacIfRightTick(this.tick);
            }
            if (this.tick >= 99) {
                ++this.times;
                this.tick = 20;
            }
            ++this.tick;
        }
        if (this.times == 8 || this.conductor.isTame() || this.conductor.level().getEntitiesOfClass(Player.class, this.conductor.getBoundingBox().inflate(45.0, 45.0, 45.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE).isEmpty()) {
            this.stop();
        }
        super.tick();
    }

    private void croacIfRightTick(int tick) {
        if (tick == 22 || tick == 24 || tick == 26 || tick == 32 || tick == 34 || tick == 36 || tick == 42 || tick == 44 || tick == 47 || tick == 49 || tick == 52 || tick == 59 || tick == 62 || tick == 65 || tick == 68 || tick == 71 || tick == 82 || tick == 85 || tick == 88 || tick == 91) {
            QuirkyFrogEntity chorister = this.choir.pollFirst();
            if (chorister == null) {
                this.stop();
            } else {
                this.croac(chorister);
                this.choir.addLast(chorister);
                this.conductor.getLookControl().setLookAt((Entity)chorister);
            }
        }
    }

    private void croac(QuirkyFrogEntity chorister) {
        chorister.triggerAnim("quirky_frog_croac_controller", "croac");
        ((ServerLevel)chorister.level()).sendParticles((ParticleOptions)ParticleTypes.NOTE, chorister.getX(), chorister.getY() + 1.5, chorister.getZ(), 1, 0.0, 0.0, 0.0, 1.0);
    }

    @Nullable
    protected Vec3 getPosition() {
        return DefaultRandomPos.getPos((PathfinderMob)this.conductor, (int)10, (int)7);
    }
}

