/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.screen.custom;

import net.migueel26.faunaandorchestra.block.custom.DiscordNucleiBlock;
import net.migueel26.faunaandorchestra.block.entity.DiscordNucleiBlockEntity;
import net.migueel26.faunaandorchestra.util.RecipesUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DiscordNucleiScreen {
    public static final int DEFAULT_TEXT_WIDTH = 160;
    public static final LayeredDraw.Layer OVERLAY = DiscordNucleiScreen::renderOverlay;

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker tracker) {
        BlockHitResult blockHitResult;
        BlockPos pos;
        BlockEntity blockEntity;
        Minecraft minecraft = Minecraft.getInstance();
        HitResult hitResult = minecraft.hitResult;
        ClientLevel level = minecraft.level;
        int centerX = guiGraphics.guiWidth() / 2 + 10;
        int centerY = guiGraphics.guiHeight() / 2 + 20;
        if (level != null && hitResult instanceof BlockHitResult && (blockEntity = level.getBlockEntity(pos = (blockHitResult = (BlockHitResult)hitResult).getBlockPos())) instanceof DiscordNucleiBlockEntity) {
            DiscordNucleiBlockEntity discordNuclei = (DiscordNucleiBlockEntity)blockEntity;
            ItemStack stack = discordNuclei.inventory.getStackInSlot(0);
            if (!stack.isEmpty()) {
                int essence = (Integer)discordNuclei.getBlockState().getValue((Property)DiscordNucleiBlock.ESSENCE);
                int normInstability = (Integer)discordNuclei.getBlockState().getValue((Property)DiscordNucleiBlock.INSTABILITY);
                int normEssence = essence * 100 / (Integer)RecipesUtil.getDiscordNucleiResult(stack).getA();
                String essenceString = Component.translatable((String)"block.faunaandorchestra.discord_nuclei.essence").getString() + normEssence + "%";
                String instabilityString = "\n" + Component.translatable((String)"block.faunaandorchestra.discord_nuclei.instability").getString() + normInstability + "%";
                String output = essenceString + instabilityString;
                guiGraphics.drawWordWrap(minecraft.font, FormattedText.of((String)output), centerX, centerY, 160, 0xFFFFFF);
            }
        }
    }
}

