/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.screen.custom;

import java.util.StringJoiner;
import net.migueel26.faunaandorchestra.block.entity.MelomancyCauldronBlockEntity;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MelomancyCauldronScreen {
    public static int MY_COUNTER = 0;
    public static final int DEFAULT_TEXT_WIDTH = 160;
    public static final LayeredDraw.Layer OVERLAY = MelomancyCauldronScreen::renderOverlay;

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker tracker) {
        BlockHitResult blockHitResult;
        BlockPos pos;
        BlockEntity blockEntity;
        Minecraft minecraft = Minecraft.getInstance();
        HitResult hitResult = minecraft.hitResult;
        ClientLevel level = minecraft.level;
        int centerX = guiGraphics.guiWidth() / 2 + 10;
        int centerY = guiGraphics.guiHeight() / 2 + 20;
        if (level != null && hitResult instanceof BlockHitResult && (blockEntity = level.getBlockEntity(pos = (blockHitResult = (BlockHitResult)hitResult).getBlockPos())) instanceof MelomancyCauldronBlockEntity) {
            MelomancyCauldronBlockEntity melomancyCauldron = (MelomancyCauldronBlockEntity)blockEntity;
            Object extra = "";
            if (melomancyCauldron.isCooking()) {
                String dots = MelomancyCauldronScreen.getDots(MY_COUNTER);
                extra = "\n\u00a7d\u00a7l" + Component.translatable((String)"block.faunaandorchestra.melomancy_cauldron.preparing").getString() + dots;
            } else if (melomancyCauldron.hasFinishedCooking()) {
                extra = "\n\u00a7d" + Component.translatable((String)"block.faunaandorchestra.melomancy_cauldron.finished").getString();
                MY_COUNTER = 0;
            }
            NonNullList<ItemStack> ingredients = melomancyCauldron.getIngredients();
            StringJoiner output = new StringJoiner(", ");
            for (ItemStack item : ingredients) {
                if (item.isEmpty()) continue;
                output.add(item.getItem().getDescription().getString() + " x" + item.getCount());
            }
            guiGraphics.drawWordWrap(minecraft.font, FormattedText.of((String)(String.valueOf(output) + (String)extra)), centerX, centerY, 160, 0xFFFFFF);
            ++MY_COUNTER;
        }
    }

    private static String getDots(int cookTime) {
        int time = cookTime % 80;
        if (time < 20) {
            return "";
        }
        if (time < 40) {
            return ".";
        }
        if (time < 60) {
            return "..";
        }
        return "...";
    }
}

