/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.screen.custom;

import java.util.List;
import net.migueel26.faunaandorchestra.entity.custom.boss.TheGreatComposer;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import oshi.util.tuples.Pair;

public class TheGreatComposerScreen {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/dialogue.png");
    public static final int DEFAULT_OFFSET = 80;
    public static final int DEFAULT_BACKGROUND_Y = 160;
    public static final int DEFAULT_BACKGROUND_X = 100;
    public static final int DEFAULT_TEXT_Y = 172;
    public static final int TRANSITION_DURATION = 40;
    public static final int DEFAULT_TEXT_WIDTH = 160;
    public static final double M = 0.5660377358490566;
    public static final double N = -241.69811320754718;
    public static final double My = 0.9760956175298805;
    public static final double Ny = -234.26294820717132;
    public static final LayeredDraw.Layer OVERLAY = TheGreatComposerScreen::renderOverlay;
    public static final int POP_UP_TIME = 160;

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker tracker) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        LocalPlayer player = minecraft.player;
        if (level != null && player != null) {
            TheGreatComposer composer;
            List candidates = level.getEntitiesOfClass(TheGreatComposer.class, player.getBoundingBox().inflate(30.0));
            TheGreatComposer theGreatComposer = composer = candidates.isEmpty() ? null : (TheGreatComposer)((Object)candidates.getFirst());
            if (composer != null && composer.shouldDisplayDialogue() && composer.getSpawnTime() > -1) {
                String text;
                ResourceLocation icon;
                int spawnTime = composer.getSpawnTime();
                int normalizedSpawnTime = spawnTime > 160 ? spawnTime - 160 : spawnTime;
                TheGreatComposer.ComposerBossState state = composer.getState();
                Pair size = new Pair((Object)49, (Object)60);
                Pair location = new Pair((Object)107, (Object)136);
                if (spawnTime < 160) {
                    icon = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/composer_spawn_icon.png");
                    text = Component.translatable((String)"dialogue.faunaandorchestra.the_great_composer0").getString();
                } else {
                    icon = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/composer_default_icon.png");
                    text = Component.translatable((String)"dialogue.faunaandorchestra.the_great_composer1").getString();
                }
                int currIconY = (Integer)location.getB() + 80;
                int currBackY = 240;
                int currTextY = 252;
                int currOffset = 80;
                String currentText = "";
                guiGraphics.pose().translate(0.0f, 0.0f, 1.0f);
                if (composer.getSpawnTime() <= 40) {
                    currOffset = (int)Math.round(80.0 * (1.0 - Math.pow(1.0 - (double)(normalizedSpawnTime - 1) / 40.0, 4.0)));
                }
                if (normalizedSpawnTime >= 120 && normalizedSpawnTime <= 160 && spawnTime > 160) {
                    currOffset = (int)Math.round(80.0 * (1.0 - Math.pow((double)(normalizedSpawnTime - 120) / 40.0, 4.0)));
                }
                currentText = TheGreatComposerScreen.typewritify(text, normalizedSpawnTime, guiGraphics, currTextY, currOffset);
                guiGraphics.blit(BACKGROUND, 100 + TheGreatComposerScreen.xOffset(guiGraphics), currBackY - currOffset + TheGreatComposerScreen.yOffset(guiGraphics), 0, 0, 223, 40);
                guiGraphics.blit(icon, (Integer)location.getA() + TheGreatComposerScreen.xOffset(guiGraphics), currIconY - currOffset + TheGreatComposerScreen.yOffset(guiGraphics), 0.0f, 0.0f, ((Integer)size.getA()).intValue(), ((Integer)size.getB()).intValue(), ((Integer)size.getA()).intValue(), ((Integer)size.getB()).intValue());
                guiGraphics.drawWordWrap(minecraft.font, FormattedText.of((String)currentText), 157 + TheGreatComposerScreen.xOffset(guiGraphics), currTextY - currOffset + TheGreatComposerScreen.yOffset(guiGraphics), 160, 0xFFFFFF);
                if (spawnTime > 315) {
                    composer.resetDialogueTimer();
                }
            }
        }
    }

    private static int xOffset(GuiGraphics guiGraphics) {
        return (int)Math.round(0.5660377358490566 * (double)guiGraphics.guiWidth() + -241.69811320754718);
    }

    private static int yOffset(GuiGraphics guiGraphics) {
        return (int)Math.round(0.9760956175298805 * (double)guiGraphics.guiHeight() + -234.26294820717132);
    }

    private static String typewritify(String fullText, int dialogueTimer, GuiGraphics guiGraphics, int currentTextY, int currentOffset) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (dialogueTimer <= fullText.length() * 2 && dialogueTimer % 2 == 0) {
            player.playSound(ModSounds.DIALOGUE.get(), 0.5f, RandomSource.create().nextFloat());
        }
        return dialogueTimer < fullText.length() * 2 ? fullText.substring(0, dialogueTimer / 2) : fullText;
    }
}

