/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.sound.custom;

import java.util.UUID;
import net.migueel26.faunaandorchestra.entity.custom.TravellingMusician;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class TravellingMusicianSoundInstance
extends AbstractTickableSoundInstance {
    TravellingMusician musician;
    private int stopDelay = 5;

    public TravellingMusicianSoundInstance(SoundEvent soundEvent, TravellingMusician musician) {
        super(soundEvent, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.musician = musician;
        this.looping = true;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.volume = this.calculateVolume();
        this.x = musician.getX();
        this.y = musician.getY();
        this.z = musician.getZ();
    }

    public void tick() {
        if (!this.musician.isPlaying() || this.musician.isRemoved()) {
            if (this.stopDelay > 0) {
                --this.stopDelay;
            } else {
                this.stopSound();
            }
        } else {
            this.stopDelay = 5;
            this.x = this.musician.getX();
            this.y = this.musician.getY();
            this.z = this.musician.getZ();
            this.volume = this.calculateVolume();
        }
    }

    private float calculateVolume() {
        double distance = Minecraft.getInstance().player.distanceTo((Entity)this.musician);
        return (float)Math.max(0.0, (double)1.1f - distance * 0.03125);
    }

    public boolean canStartSilent() {
        return true;
    }

    public void stopSound() {
        super.stop();
    }

    public UUID getUUID() {
        return this.musician.getUUID();
    }
}

