/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import java.util.Iterator;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FlowerGrowerDiscordBlock
extends Block {
    public static final IntegerProperty GENERATION = IntegerProperty.create((String)"generation", (int)0, (int)100);
    public static final IntegerProperty MAX_GENERATION = IntegerProperty.create((String)"max_generation", (int)0, (int)100);

    public FlowerGrowerDiscordBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)GENERATION, (Comparable)Integer.valueOf(0))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(3)));
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        level.scheduleTick(pos, (Block)this, this.getNewChildTime(level));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().magic(), 2.0f);
        }
        if (!level.isClientSide()) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, entity.getX(), entity.getY(), entity.getZ(), 3, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.01f);
        }
        super.stepOn(level, pos, state, entity);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().magic(), 2.0f);
        }
        if (!level.isClientSide()) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, entity.getX(), entity.getY(), entity.getZ(), 1, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.05f);
        }
        super.entityInside(state, level, pos, entity);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)GENERATION) < (Integer)state.getValue((Property)MAX_GENERATION)) {
            int myGeneration = (Integer)state.getValue((Property)GENERATION);
            int maxGeneration = (Integer)state.getValue((Property)MAX_GENERATION);
            Iterator iterator = BlockPos.betweenClosed((BlockPos)new BlockPos(pos.getX() + 1, pos.getY() + 1, pos.getZ() + 1), (BlockPos)new BlockPos(pos.getX() - 1, pos.getY() - 1, pos.getZ() - 1)).iterator();
            if (myGeneration <= 3) {
                level.playSound(null, pos, SoundEvents.SCULK_CLICKING, SoundSource.BLOCKS, 1.0f, 1.0f + (level.random.nextFloat() - 0.5f));
            }
            int time = 0;
            while (iterator.hasNext()) {
                BlockPos nextPos = (BlockPos)iterator.next();
                BlockState nextState = level.getBlockState(nextPos);
                if (time % 2 == 0 && !nextState.isAir() && FlowerGrowerDiscordBlock.isNotProhibited(nextState) && this.canHaveChild(myGeneration, maxGeneration, (Level)level)) {
                    level.setBlock(nextPos, (BlockState)((BlockState)((Block)ModBlocks.FLOWER_DISCORD_BLOCK.get()).defaultBlockState().setValue((Property)GENERATION, (Comparable)Integer.valueOf(myGeneration + 1))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(maxGeneration)), 3);
                }
                ++time;
            }
        }
    }

    private boolean canHaveChild(int myGeneration, int maxGeneration, Level level) {
        int diff = maxGeneration - myGeneration;
        if (diff > 3) {
            return true;
        }
        float chance = level.random.nextFloat();
        if (diff == 3) {
            return chance < 0.5f;
        }
        if (diff > 0) {
            return chance < 0.25f;
        }
        return false;
    }

    public static boolean isNotProhibited(BlockState nextState) {
        return !nextState.is(ModBlocks.COMPOSER_GRAVESTONE) && !nextState.is(ModBlocks.DISCORDED_FLOWER) && !nextState.is(Blocks.END_PORTAL) && !nextState.is(Blocks.BEDROCK) && !nextState.is(Blocks.CHEST) && !nextState.is(ModBlocks.DISCORD_NUCLEI);
    }

    private int getNewChildTime(Level level) {
        return level.random.nextInt(5, 10);
    }

    private boolean canGrab(BlockPos newPos, ServerLevel level) {
        return !level.getBlockState(newPos.east()).isAir() && !level.getBlockState(newPos.east()).is(ModBlocks.CRAWLING_DISCORD) || !level.getBlockState(newPos.west()).isAir() && !level.getBlockState(newPos.west()).is(ModBlocks.CRAWLING_DISCORD) || !level.getBlockState(newPos.north()).isAir() && !level.getBlockState(newPos.north()).is(ModBlocks.CRAWLING_DISCORD) || !level.getBlockState(newPos.south()).isAir() && !level.getBlockState(newPos.south()).is(ModBlocks.CRAWLING_DISCORD);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GENERATION, MAX_GENERATION});
    }
}

