/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.migueel26.faunaandorchestra.entity.custom.projectile.MusicNoteProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class MusicNoteProjectileRenderer
extends EntityRenderer<MusicNoteProjectileEntity> {
    private int tick = 0;
    private static final ResourceLocation MAIN_TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/music_note_projectile.png");
    private static final ResourceLocation BACK_TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/music_note_projectile_back.png");
    private static final RenderType MAIN_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)MAIN_TEXTURE_LOCATION);
    private static final RenderType BACK_RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)BACK_TEXTURE_LOCATION);

    public MusicNoteProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getBlockLightLevel(MusicNoteProjectileEntity entity, BlockPos pos) {
        return 15;
    }

    public void render(MusicNoteProjectileEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.pushPose();
        float i = (float)(0.25 * Math.sin((double)this.tick * 0.075) + 1.75);
        poseStack.scale(i, i, i);
        poseStack.translate(0.0, -0.05, -0.001);
        PoseStack.Pose backPose = poseStack.last();
        VertexConsumer backConsumer = buffer.getBuffer(BACK_RENDER_TYPE);
        MusicNoteProjectileRenderer.vertex(backConsumer, backPose, packedLight, 0.0f, 0, 0, 1, 128);
        MusicNoteProjectileRenderer.vertex(backConsumer, backPose, packedLight, 1.0f, 0, 1, 1, 128);
        MusicNoteProjectileRenderer.vertex(backConsumer, backPose, packedLight, 1.0f, 1, 1, 0, 128);
        MusicNoteProjectileRenderer.vertex(backConsumer, backPose, packedLight, 0.0f, 1, 0, 0, 128);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(1.5f, 1.5f, 1.5f);
        PoseStack.Pose mainPose = poseStack.last();
        VertexConsumer mainConsumer = buffer.getBuffer(MAIN_RENDER_TYPE);
        MusicNoteProjectileRenderer.vertex(mainConsumer, mainPose, packedLight, 0.0f, 0, 0, 1, 255);
        MusicNoteProjectileRenderer.vertex(mainConsumer, mainPose, packedLight, 1.0f, 0, 1, 1, 255);
        MusicNoteProjectileRenderer.vertex(mainConsumer, mainPose, packedLight, 1.0f, 1, 1, 0, 255);
        MusicNoteProjectileRenderer.vertex(mainConsumer, mainPose, packedLight, 0.0f, 1, 0, 0, 255);
        poseStack.popPose();
        poseStack.popPose();
        ++this.tick;
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v, int alpha) {
        consumer.addVertex(pose, x - 0.5f, (float)y - 0.25f, 0.0f).setColor(255, 255, 255, alpha).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(MusicNoteProjectileEntity entity) {
        return MAIN_TEXTURE_LOCATION;
    }
}

