/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.effect;

import java.util.Optional;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.entity.custom.WanderingNoteEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class AbsoluteHearingEffect
extends MobEffect {
    protected AbsoluteHearingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Optional<ConductorEntity> conductor = livingEntity.level().getNearbyEntities(ConductorEntity.class, TargetingConditions.DEFAULT, livingEntity, livingEntity.getBoundingBox().inflate(15.0)).stream().filter(ConductorEntity::isHoldingASheetMusic).filter(ConductorEntity::isConducting).findAny();
        if (conductor.isPresent() && livingEntity.tickCount % 40 == 0 && !livingEntity.level().isClientSide()) {
            WanderingNoteEntity entity = new WanderingNoteEntity(ModEntities.WANDERING_NOTE.get(), livingEntity.level());
            int x = livingEntity.getRandom().nextInt(9) - 4;
            int z = livingEntity.getRandom().nextInt(3);
            int y = livingEntity.getRandom().nextInt(9) - 4;
            entity.moveTo(livingEntity.getX() + (double)x, livingEntity.getY() + (double)y, livingEntity.getZ() + (double)z);
            livingEntity.level().addFreshEntity((Entity)entity);
            entity.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.5f);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

