/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import net.migueel26.faunaandorchestra.entity.custom.MacawEntity;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.goals.MusicalEntityPlayingInstrumentGoal;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MadameButterflyEntity
extends MusicalEntity
implements GeoEntity,
FlyingAnimal {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation IDLE_CELLO = RawAnimation.begin().thenPlay("idle_cello");
    protected static final RawAnimation PLAYING_CELLO = RawAnimation.begin().thenPlay("playing_cello");
    protected static final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    protected static final RawAnimation FLY_CELLO = RawAnimation.begin().thenPlay("fly_cello");
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;
    private boolean changingInstrument = false;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MadameButterflyEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.addOverridenGoals();
    }

    @Override
    public DeferredItem<Item> getInstrument() {
        return ModItems.CELLO;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MusicalEntityPlayingInstrumentGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new MadameButterflyWanderGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private void addOverridenGoals() {
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 8.0f){

            public void tick() {
                super.tick();
                if (this.lookAt.isAlive() && ((MusicalEntity)this.mob).isHoldingInstrument()) {
                    this.mob.getLookControl().setLookAt(this.lookAt.getX(), this.lookAt.getEyeY() - 5.0, this.lookAt.getZ());
                }
            }
        });
    }

    private <E extends GeoAnimatable> PlayState madameButterflyState(AnimationState<E> state) {
        if (this.isRotating() && this.isHoldingInstrument() && !this.isFlying()) {
            state.getController().setAnimation(IDLE_CELLO);
        } else if (this.isFlying() && this.isHoldingInstrument()) {
            state.getController().setAnimation(FLY_CELLO);
        } else if (this.isPlayingInstrument()) {
            state.getController().setAnimation(PLAYING_CELLO);
        } else if (this.isHoldingInstrument()) {
            state.getController().setAnimation(IDLE_CELLO);
        } else if (this.isFlying()) {
            state.getController().setAnimation(FLY);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)0.4f).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.entityData.set(IS_MUSICAL, (Object)true);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.onGround() && !this.isPassenger() ? 4 : -1) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public void aiStep() {
        super.aiStep();
        this.calculateFlapping();
    }

    @Override
    public void setHoldingInstrument(boolean holdingInstrument) {
        super.setHoldingInstrument(holdingInstrument);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isHoldingInstrument()) {
            return super.getDefaultDimensions(pose).scale(1.5f, 2.75f);
        }
        return super.getDefaultDimensions(pose);
    }

    @Override
    public void tick() {
        if (this.level().isClientSide() && this.changingInstrument != this.isHoldingInstrument()) {
            this.changingInstrument = this.isHoldingInstrument();
            this.refreshDimensions();
        }
        super.tick();
    }

    public static boolean checkMacawSpawnRules(EntityType<MacawEntity> macaw, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.PARROTS_SPAWNABLE_ON) && MadameButterflyEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isPlayingInstrument() ? null : SoundEvents.PARROT_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.PARROT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PARROT_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound(SoundEvents.PARROT_STEP, 0.15f, 1.0f);
    }

    protected void onFlap() {
        this.playSound(SoundEvents.PARROT_FLY, 0.15f, 1.0f);
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    public boolean isRotating() {
        return Math.abs(this.yBodyRot - this.yBodyRotO) > 0.01f;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "madame_butterfly_controller", 5, this::madameButterflyState));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    static class MadameButterflyWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        public MadameButterflyWanderGoal(PathfinderMob p_186224_, double p_186225_) {
            super(p_186224_, p_186225_);
        }

        public boolean canUse() {
            return super.canUse() & !((MadameButterflyEntity)this.mob).isOrderedToSit() && !((MadameButterflyEntity)this.mob).isPlayingInstrument();
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vec3 = null;
            if (this.mob.isInWater()) {
                vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)15);
            }
            if (this.mob.getRandom().nextFloat() >= this.probability) {
                vec3 = this.getTreePos();
            }
            return vec3 == null ? super.getPosition() : vec3;
        }

        @Nullable
        private Vec3 getTreePos() {
            BlockPos blockpos = this.mob.blockPosition();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.betweenClosed((int)Mth.floor((double)(this.mob.getX() - 3.0)), (int)Mth.floor((double)(this.mob.getY() - 6.0)), (int)Mth.floor((double)(this.mob.getZ() - 3.0)), (int)Mth.floor((double)(this.mob.getX() + 3.0)), (int)Mth.floor((double)(this.mob.getY() + 6.0)), (int)Mth.floor((double)(this.mob.getZ() + 3.0)))) {
                BlockState blockstate;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (blockstate = this.mob.level().getBlockState((BlockPos)blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos1, Direction.DOWN))).getBlock() instanceof LeavesBlock || blockstate.is(BlockTags.LOGS)) || !this.mob.level().isEmptyBlock(blockpos1) || !this.mob.level().isEmptyBlock((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.atBottomCenterOf((Vec3i)blockpos1);
            }
            return null;
        }
    }
}

