/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom.projectile;

import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.CrawlingDiscordBlock;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ThrownDiscordBomb
extends ThrowableItemProjectile
implements ItemSupplier {
    public ThrownDiscordBomb(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownDiscordBomb(Level level, LivingEntity shooter) {
        super(ModEntities.THROWN_DISCORD_BOMB.get(), shooter, level);
    }

    public ThrownDiscordBomb(Level level, double x, double y, double z) {
        super(ModEntities.THROWN_DISCORD_BOMB.get(), x, y, z, level);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.BOOGIE_BOMB.get();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            Vec3 vec3 = result.getLocation();
            this.level().playSound(null, vec3.x, vec3.y, vec3.z, SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.level().playSound(null, vec3.x, vec3.y, vec3.z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.NEUTRAL, 1.0f, 0.5f);
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, vec3.x, vec3.y, vec3.z, 50, 0.25, 0.25, 0.25, 0.1);
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, vec3.x, vec3.y, vec3.z, 80, 0.75, 0.75, 0.75, 0.2);
            this.level().setBlock(BlockPos.containing((double)vec3.x, (double)vec3.y, (double)vec3.z), (BlockState)((Block)ModBlocks.CRAWLING_DISCORD.get()).defaultBlockState().setValue((Property)CrawlingDiscordBlock.MAX_GENERATION, (Comparable)Integer.valueOf(7)), 3);
            this.discard();
        }
    }
}

