/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import java.util.Iterator;
import java.util.Optional;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.DamBlock;
import net.migueel26.faunaandorchestra.entity.custom.BeaverEntity;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Pair;

public class BeaverBuildsDamGoal
extends Goal {
    public static final int DEFAULT_COOLDOWN = 100;
    public static final int INITIAL_DEFAULT_COOLDOWN = 200;
    protected final BeaverEntity beaver;
    protected final Level level;
    protected Vec3 wantedPathBlock;
    protected BlockPos waterPos;
    protected int tick;
    protected int cooldown;
    protected boolean finish = false;
    protected boolean isDam = false;

    public BeaverBuildsDamGoal(BeaverEntity beaver, double speedModifier) {
        this.beaver = beaver;
        this.level = beaver.level();
        this.cooldown = 200;
    }

    public boolean canUse() {
        Pair<Vec3, BlockPos> pair;
        --this.cooldown;
        if (!this.beaver.isHoldingInstrument() && this.cooldown <= 0 && (pair = this.getDamPosition()) != null) {
            this.wantedPathBlock = (Vec3)pair.getA();
            this.waterPos = (BlockPos)pair.getB();
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.beaver.isDeadOrDying() && !this.beaver.isHoldingInstrument() && !this.finish;
    }

    public void start() {
        this.beaver.getNavigation().moveTo(this.wantedPathBlock.x, this.wantedPathBlock.y, this.wantedPathBlock.z, 0, 1.0);
        this.tick = -1;
        this.finish = false;
    }

    public void stop() {
        if (this.isDam) {
            this.waterPos = new BlockPos(this.waterPos.getX(), this.waterPos.getY() + 1, this.waterPos.getZ());
        }
        if ((double)this.waterPos.getZ() != this.wantedPathBlock.z || (double)this.waterPos.getX() != this.wantedPathBlock.x) {
            this.level.setBlock(this.waterPos, (BlockState)((Block)ModBlocks.DAM_BLOCK.get()).defaultBlockState().setValue((Property)DamBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.waterPos = null;
        this.wantedPathBlock = null;
        this.finish = false;
        this.tick = -1;
        this.cooldown = 100;
        this.beaver.setBuilding(false);
    }

    private Pair<Vec3, BlockPos> getDamPosition() {
        BlockPos pathBlock = null;
        Optional water = BlockPos.findClosestMatch((BlockPos)this.beaver.blockPosition(), (int)20, (int)3, this::isWaterApt);
        Optional dam = BlockPos.findClosestMatch((BlockPos)this.beaver.blockPosition(), (int)20, (int)3, pred -> this.level.getBlockState(pred).getBlock() == ModBlocks.DAM_BLOCK.get());
        BlockPos waterPos = null;
        if (water.isPresent()) {
            waterPos = ((BlockPos)water.get()).immutable();
            int x = waterPos.getX();
            int y = waterPos.getY();
            int z = waterPos.getZ();
            this.isDam = false;
            if (dam.isPresent() && this.isDam) {
                waterPos = ((BlockPos)dam.get()).immutable();
                x = waterPos.getX();
                y = waterPos.getY();
                z = waterPos.getZ();
            }
            Iterator iterator = BlockPos.betweenClosed((BlockPos)new BlockPos(x + 1, y, z + 1), (BlockPos)new BlockPos(x - 1, y, z - 1)).iterator();
            while (iterator.hasNext() && pathBlock == null) {
                BlockPos blockPos = (BlockPos)iterator.next();
                if (blockPos == waterPos || this.level.getBlockState(blockPos).getBlock() == Blocks.WATER || this.level.getBlockState(blockPos.above()).getBlock() != Blocks.AIR) continue;
                pathBlock = blockPos.immutable();
            }
        }
        return pathBlock == null ? null : new Pair((Object)pathBlock.getCenter(), (Object)waterPos);
    }

    private boolean isWaterApt(BlockPos pred) {
        return this.level.getBlockState(pred).is(Blocks.WATER) && this.level.getBlockState(pred.above()).is(Blocks.AIR);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.beaver.getNavigation().isDone() && this.tick == -1) {
            Vec3 tp = new Vec3(this.wantedPathBlock.x, this.wantedPathBlock.y + 0.5, this.wantedPathBlock.z);
            this.beaver.moveTo(tp);
            this.beaver.build();
            this.level.playSound(null, this.beaver.blockPosition(), ModSounds.BEAVER_TEETH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.tick = 0;
        }
        if (this.tick >= 0) {
            if (this.tick == 80) {
                this.finish = true;
            } else {
                ++this.tick;
            }
        }
    }
}

