/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.migueel26.faunaandorchestra.worldgen.structures.ModStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

class TerrainAdjustedStructure
extends Structure {
    public static final MapCodec<TerrainAdjustedStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TerrainAdjustedStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)JigsawStructure.DEFAULT_DIMENSION_PADDING).forGetter(structure -> structure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, TerrainAdjustedStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    public TerrainAdjustedStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.TERRAIN_ADJUSTED_STRUCTURE.get();
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        int groundY;
        BlockPos center = context.chunkPos().getMiddleBlockPosition(0);
        int waterSurfaceY = context.chunkGenerator().getFirstOccupiedHeight(center.getX(), center.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        boolean isUnderwater = waterSurfaceY - (groundY = context.chunkGenerator().getFirstOccupiedHeight(center.getX(), center.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState())) > 0;
        return !isUnderwater;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (!TerrainAdjustedStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.chunkPos();
        BlockPos center = context.chunkPos().getMiddleBlockPosition(0);
        int surfaceY = context.chunkGenerator().getFirstOccupiedHeight(center.getX(), center.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        BlockPos spawnPos = new BlockPos(center.getX(), surfaceY + 2, center.getZ());
        return this.generatePieces(context, spawnPos);
    }

    public Optional<Structure.GenerationStub> generatePieces(Structure.GenerationContext context, BlockPos spawnPos) {
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)this.size, (BlockPos)spawnPos, (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)this.dimensionPadding, (LiquidSettings)this.liquidSettings);
    }
}

