/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.UUID;
import net.migueel26.faunaandorchestra.block.entity.TipCaseBlockEntity;
import net.migueel26.faunaandorchestra.entity.custom.Faust;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipCaseBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<TipCaseBlock> CODEC = TipCaseBlock.simpleCodec(TipCaseBlock::new);
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final int FIRST_REWARD = 6;
    public static final int SECOND_REWARD = 24;
    public static final int THIRD_REWARD = 64;
    public static final IntegerProperty TIPS = IntegerProperty.create((String)"tip_amount", (int)0, (int)64);
    public static final BooleanProperty FIRST = BooleanProperty.create((String)"first");
    public static final BooleanProperty SECOND = BooleanProperty.create((String)"second");
    public static final BooleanProperty THIRD = BooleanProperty.create((String)"third");
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)5.0, (double)11.0), (VoxelShape)Block.box((double)3.75, (double)0.0, (double)10.0, (double)12.25, (double)5.0, (double)16.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)3.75, (double)0.0, (double)0.0, (double)12.25, (double)5.0, (double)5.0), (VoxelShape)Block.box((double)2.5, (double)0.0, (double)5.0, (double)13.5, (double)5.0, (double)13.5));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)3.75, (double)5.0, (double)5.0, (double)12.25), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)2.5, (double)13.5, (double)5.0, (double)13.5));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)Block.box((double)2.5, (double)0.0, (double)2.5, (double)11.0, (double)5.0, (double)13.5), (VoxelShape)Block.box((double)10.0, (double)0.0, (double)3.75, (double)16.0, (double)5.0, (double)12.25));
    public static final VoxelShape NORTH_SHAPE_H = Block.box((double)5.5, (double)0.0, (double)0.0, (double)10.5, (double)5.0, (double)13.9);
    public static final VoxelShape SOUTH_SHAPE_H = Block.box((double)5.5, (double)0.0, (double)2.1, (double)10.5, (double)5.0, (double)16.0);
    public static final VoxelShape EAST_SHAPE_H = Block.box((double)2.1, (double)0.0, (double)5.5, (double)16.0, (double)5.0, (double)10.5);
    public static final VoxelShape WEST_SHAPE_H = Block.box((double)0.0, (double)0.0, (double)5.5, (double)13.9, (double)5.0, (double)10.5);

    public TipCaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)TIPS, (Comparable)Integer.valueOf(0))).setValue((Property)FIRST, (Comparable)Boolean.valueOf(true))).setValue((Property)SECOND, (Comparable)Boolean.valueOf(true))).setValue((Property)THIRD, (Comparable)Boolean.valueOf(true)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (TipCaseBlock.getConnectedDirection(state)) {
            case Direction.NORTH -> {
                if (state.getValue(PART) == BedPart.FOOT) {
                    yield NORTH_SHAPE;
                }
                yield NORTH_SHAPE_H;
            }
            case Direction.SOUTH -> {
                if (state.getValue(PART) == BedPart.FOOT) {
                    yield SOUTH_SHAPE;
                }
                yield SOUTH_SHAPE_H;
            }
            case Direction.WEST -> {
                if (state.getValue(PART) == BedPart.FOOT) {
                    yield WEST_SHAPE;
                }
                yield WEST_SHAPE_H;
            }
            default -> state.getValue(PART) == BedPart.FOOT ? EAST_SHAPE : EAST_SHAPE_H;
        };
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return state.getValue(PART) == BedPart.FOOT ? direction.getOpposite() : direction;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TipCaseBlockEntity(pos, state);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == TipCaseBlock.getNeighbourDirection((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            if (neighborState.is((Block)this) && neighborState.getValue(PART) != state.getValue(PART)) {
                return (BlockState)state.setValue((Property)TIPS, (Comparable)((Integer)neighborState.getValue((Property)TIPS)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            BlockPos blockPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            level.setBlock(blockPos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
            ((TipCaseBlockEntity)level.getBlockEntity(blockPos)).setOwner(placer.getUUID());
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        Level level = context.getLevel();
        return level.getBlockState(blockpos1).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockpos1) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : null;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        if (player.getUUID().equals(((TipCaseBlockEntity)blockEntity).getOwner())) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)Items.GOLD_INGOT, ((Integer)state.getValue((Property)TIPS)).intValue())));
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getItemInHand(hand).is(Items.GOLD_INGOT) && (Integer)state.getValue((Property)TIPS) < 64) {
            stack.consume(1, (LivingEntity)player);
            int tips = (Integer)state.getValue((Property)TIPS) + 1;
            level.setBlock(pos, (BlockState)state.setValue((Property)TIPS, (Comparable)Integer.valueOf(tips)), 3);
            if (!level.isClientSide()) {
                TipCaseBlockEntity blockEntity = (TipCaseBlockEntity)level.getBlockEntity(pos);
                Entity entity = null;
                if (blockEntity.getOwner() != null) {
                    entity = ((ServerLevel)level).getEntity(blockEntity.getOwner());
                }
                if (entity instanceof Faust) {
                    TipCaseBlock.giveRingtailsTipAward(state, level, pos, player, tips);
                }
            }
        } else {
            if (player.getItemInHand(hand).is(Items.GOLD_INGOT) && (Integer)state.getValue((Property)TIPS) == 64) {
                return ItemInteractionResult.FAIL;
            }
            if (player.getItemInHand(hand).isEmpty() && (Integer)state.getValue((Property)TIPS) > 0 && !level.isClientSide()) {
                UUID playerUUID;
                UUID tipCaseUUID = ((TipCaseBlockEntity)level.getBlockEntity(pos)).getOwner();
                if (tipCaseUUID.equals(playerUUID = player.getUUID())) {
                    int tips = (Integer)state.getValue((Property)TIPS);
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.GOLD_INGOT, tips));
                    level.setBlock(pos, (BlockState)state.setValue((Property)TIPS, (Comparable)Integer.valueOf(0)), 3);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"block.faunaandorchestra.tip_case_theft"), true);
                }
            }
        }
        if (!level.isClientSide()) {
            Vec3 center = pos.getCenter();
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WAX_ON, center.x, center.y, center.z, 2, 0.15, 0.15, 0.15, 0.5);
        } else {
            level.playSound(player, pos, SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private static void giveRingtailsTipAward(BlockState state, Level level, BlockPos pos, Player player, int tips) {
        if (tips == 6 && ((Boolean)state.getValue((Property)FIRST)).booleanValue()) {
            TipCaseBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModItems.MUSIC_BOTTLE.get()));
            level.playSound(null, pos, ModSounds.SUCCESSFUL_TAME.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (tips == 24 && ((Boolean)state.getValue((Property)SECOND)).booleanValue()) {
            TipCaseBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModItems.SHEET_FRAGMENTS.get()));
            level.playSound(null, pos, ModSounds.SUCCESSFUL_TAME.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (tips == 64 && ((Boolean)state.getValue((Property)THIRD)).booleanValue()) {
            TipCaseBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModItems.RINGTAILS_POSTER.get()));
            level.playSound(null, pos, ModSounds.SUCCESSFUL_TAME.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        TipCaseBlockEntity blockEntity = (TipCaseBlockEntity)level.getBlockEntity(pos);
        if (!level.isClientSide() && blockEntity.getOwner() != null && TipCaseBlock.faustIsRemoved(level, blockEntity)) {
            blockEntity.setOwner(null);
            BlockPos blockPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            ((TipCaseBlockEntity)level.getBlockEntity(blockPos)).setOwner(null);
        }
        super.tick(state, level, pos, random);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"block.faunaandorchestra.tip_case.desc").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra.shift"));
        }
    }

    private static boolean faustIsRemoved(ServerLevel level, TipCaseBlockEntity blockEntity) {
        Faust faust;
        Entity entity = level.getEntity(blockEntity.getOwner());
        return entity instanceof Faust && ((faust = (Faust)entity).isDeadOrDying() || faust.isRemoved());
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.HEAD ? direction : direction.getOpposite();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, TIPS, FIRST, SECOND, THIRD});
    }
}

