/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.entity;

import javax.annotation.Nullable;
import net.migueel26.faunaandorchestra.block.ModBlockEntities;
import net.migueel26.faunaandorchestra.block.custom.DiscordNucleiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DiscordNucleiBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation UNSTABLE = RawAnimation.begin().thenPlay("unstable");
    private static final RawAnimation VERY_UNSTABLE = RawAnimation.begin().thenPlay("very_unstable");
    private final AnimationController<DiscordNucleiBlockEntity> controller = new AnimationController((GeoAnimatable)this, "discord_nuclei_controller", 5, this::animController);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            DiscordNucleiBlockEntity.this.setChanged();
            if (!DiscordNucleiBlockEntity.this.level.isClientSide()) {
                DiscordNucleiBlockEntity.this.level.sendBlockUpdated(DiscordNucleiBlockEntity.this.getBlockPos(), DiscordNucleiBlockEntity.this.getBlockState(), DiscordNucleiBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private float rotation;

    public DiscordNucleiBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.DISCORD_NUCLEI_BE.get(), pos, blockState);
    }

    protected <E extends DiscordNucleiBlockEntity> PlayState animController(AnimationState<E> state) {
        int instability = (Integer)this.getBlockState().getValue((Property)DiscordNucleiBlock.INSTABILITY);
        if (instability < 20) {
            state.getController().setAnimation(IDLE);
        } else if (instability < 60) {
            state.getController().setAnimation(UNSTABLE);
        } else {
            state.getController().setAnimation(VERY_UNSTABLE);
        }
        return PlayState.CONTINUE;
    }

    public float getRenderingRotation() {
        this.rotation += 0.5f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    public void clearContents() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

