/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity;

import net.migueel26.faunaandorchestra.entity.custom.BeaverEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class BeaverModel
extends GeoModel<BeaverEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/beaver.png");
    private static final ResourceLocation ANIMATIONS = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"animations/entity/beaver.animation.json");
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"geo/entity/beaver.geo.json");

    public ResourceLocation getModelResource(BeaverEntity animatable) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(BeaverEntity animatable) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(BeaverEntity animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(BeaverEntity beaver, long instanceId, AnimationState<BeaverEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null && !beaver.isPlayingInstrument()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            if (beaver.isHoldingInstrument() || beaver.isBuilding()) {
                head.setRotX((entityData.headPitch() - 90.0f) * ((float)Math.PI / 180));
                head.setRotZ(-entityData.netHeadYaw() * ((float)Math.PI / 180));
            } else {
                head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
                head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
            }
        }
        GeoBone saxophone = this.getAnimationProcessor().getBone("saxophone");
        saxophone.setHidden(!beaver.isHoldingInstrument());
    }
}

