/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity;

import net.migueel26.faunaandorchestra.entity.custom.PenguinEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class PenguinModel
extends GeoModel<PenguinEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/penguin.png");
    private static final ResourceLocation ANIMATIONS = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"animations/entity/penguin.animation.json");
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"geo/entity/penguin.geo.json");

    public ResourceLocation getModelResource(PenguinEntity animatable) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(PenguinEntity animatable) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(PenguinEntity animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(PenguinEntity penguin, long instanceId, AnimationState<PenguinEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null && !penguin.isPlayingInstrument() && !animationState.isMoving()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        GeoBone flute = this.getAnimationProcessor().getBone("long_flute");
        flute.setHidden(!penguin.isHoldingInstrument());
    }
}

