/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.ComposerGravestoneBlock;
import net.migueel26.faunaandorchestra.block.entity.ComposerGravestoneBlockEntity;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.custom.PlayerCanonEntity;
import net.migueel26.faunaandorchestra.entity.custom.boss.TheGreatComposer;
import net.migueel26.faunaandorchestra.entity.custom.projectile.PhantomNoteProjectileEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.migueel26.faunaandorchestra.screen.custom.ConductorMenu;
import net.migueel26.faunaandorchestra.util.ModTags;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class ConductorEntity
extends TamableAnimal {
    protected static final EntityDataAccessor<Boolean> HOLDING_BATON = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> IS_LEGENDARY_BATON = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> IS_MUSICAL = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> IS_CONDUCTING = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> IS_READY = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Float> VOLUME = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected boolean holdingBaton = false;
    protected boolean isConducting = false;
    protected boolean isReady = false;
    protected Set<MusicalEntity> orchestra = new HashSet<MusicalEntity>();
    private float currentVolume = 1.0f;
    private boolean particlesActivated = true;
    public ItemStackHandler inventory = new ItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.is(ModTags.Items.SHEET_MUSIC);
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }
    };
    protected int ticksPlaying = 0;
    protected BlockPos composerGrave = null;

    public ConductorEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOLDING_BATON, (Object)false);
        builder.define(IS_LEGENDARY_BATON, (Object)false);
        builder.define(IS_CONDUCTING, (Object)false);
        builder.define(IS_READY, (Object)false);
        builder.define(IS_MUSICAL, (Object)false);
        builder.define(VOLUME, (Object)Float.valueOf(1.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (HOLDING_BATON.equals(key)) {
            this.holdingBaton = (Boolean)this.entityData.get(HOLDING_BATON);
        }
        if (IS_CONDUCTING.equals(key)) {
            this.isConducting = (Boolean)this.entityData.get(IS_CONDUCTING);
        }
        if (IS_READY.equals(key)) {
            this.isReady = (Boolean)this.entityData.get(IS_READY);
        }
        if (VOLUME.equals(key)) {
            this.currentVolume = ((Float)this.entityData.get(VOLUME)).floatValue();
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        ItemStack itemstack;
        super.readAdditionalSaveData(compound);
        this.entityData.set(HOLDING_BATON, (Object)compound.getBoolean("HoldingBaton"));
        this.entityData.set(IS_LEGENDARY_BATON, (Object)compound.getBoolean("LegendaryBaton"));
        this.entityData.set(IS_READY, (Object)compound.getBoolean("IsReady"));
        this.entityData.set(VOLUME, (Object)Float.valueOf(compound.getFloat("Volume")));
        if (compound.contains("SheetMusic") && (itemstack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("SheetMusic")).orElse(ItemStack.EMPTY)).is(ModTags.Items.SHEET_MUSIC)) {
            this.inventory.setStackInSlot(0, itemstack);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HoldingBaton", this.isHoldingBaton());
        compound.putBoolean("LegendaryBaton", this.isHoldingLegendaryBaton());
        compound.putBoolean("IsReady", this.isConducting());
        compound.putFloat("Volume", this.currentVolume);
        if (!this.inventory.getStackInSlot(0).isEmpty()) {
            compound.put("SheetMusic", this.inventory.getStackInSlot(0).save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    public void tick() {
        if (this.isTame() && this.isConducting()) {
            if (!this.level().isClientSide()) {
                this.ticksPlaying = !this.isOrchestraEmpty() ? ++this.ticksPlaying : 0;
            } else if (this.particlesActivated) {
                if (this.ticksPlaying == 0) {
                    this.level().addParticle((ParticleOptions)ModParticleTypes.TREBLE_CLEF.get(), this.getX(), this.getY() + 2.5, this.getZ(), 0.0, (double)0.025f, 0.0);
                } else if (this.ticksPlaying % 15 == 0) {
                    this.level().addParticle((ParticleOptions)ModParticleTypes.FAUNA_NOTES.get(), this.getX(), this.getY() + 2.5, this.getZ(), 0.0, (double)0.025f, 0.0);
                }
                ++this.ticksPlaying;
            } else {
                this.ticksPlaying = 0;
            }
            if (this.getSheetMusic() == ModItems.RESURRECTION_SONG.get()) {
                this.tryToResurrect();
            }
            if (this.isHoldingLegendaryBaton() && this.isHoldingASheetMusic() && this.isOrchestraFull()) {
                this.tryToApplyLegendaryEffect();
            }
        }
        super.tick();
    }

    private void tryToResurrect() {
        if (this.ticksPlaying >= 1 && this.ticksPlaying <= 5) {
            Optional candidate = BlockPos.findClosestMatch((BlockPos)this.blockPosition(), (int)7, (int)7, pos -> this.level().getBlockState(pos).is(ModBlocks.COMPOSER_GRAVESTONE));
            candidate.ifPresent(pos -> {
                this.composerGrave = pos;
            });
        }
        if (this.composerGrave != null && this.isOrchestraFull()) {
            BlockEntity blockEntity;
            BlockState graveState;
            if (this.ticksPlaying > 5 && this.ticksPlaying % 10 == 0 && !this.level().isClientSide()) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.composerGrave.getCenter().x, (double)this.composerGrave.getY(), this.composerGrave.getCenter().z, 20, 1.0, 0.3, 1.0, 0.01);
            }
            if (this.ticksPlaying == 2500 && (graveState = this.level().getBlockState(this.composerGrave)).is(ModBlocks.COMPOSER_GRAVESTONE) && !((Boolean)graveState.getValue((Property)ComposerGravestoneBlock.OPENED)).booleanValue() && (blockEntity = this.level().getBlockEntity(this.composerGrave)) instanceof ComposerGravestoneBlockEntity) {
                ComposerGravestoneBlockEntity composerGravestoneBE = (ComposerGravestoneBlockEntity)blockEntity;
                this.startResurrection(composerGravestoneBE, graveState);
            }
        }
    }

    private void startResurrection(ComposerGravestoneBlockEntity composerGravestoneBE, BlockState graveState) {
        if (!this.level().isClientSide()) {
            EntityType.LIGHTNING_BOLT.spawn((ServerLevel)this.level(), this.composerGrave, MobSpawnType.MOB_SUMMONED);
        }
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
        this.ticksPlaying = 0;
        this.level().setBlock(this.composerGrave, (BlockState)graveState.setValue((Property)ComposerGravestoneBlock.OPENED, (Comparable)Boolean.valueOf(true)), 3);
        this.level().playSound(null, this.composerGrave, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 0.5f);
        composerGravestoneBE.open();
        if (!this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.STONE.defaultBlockState()), (double)this.composerGrave.getX(), (double)((float)this.composerGrave.getY() + 0.5f), (double)this.composerGrave.getZ(), 20, 0.2, 0.0, 0.2, 1.0);
        }
        TheGreatComposer theGreatComposer = new TheGreatComposer(ModEntities.THE_GREAT_COMPOSER.get(), this.level());
        theGreatComposer.setPos(this.composerGrave.getCenter().x, this.composerGrave.below().getY(), this.composerGrave.getCenter().z);
        theGreatComposer.setSpawnPos(this.composerGrave.below());
        theGreatComposer.setYHeadRot(this.getYRot((Direction)graveState.getValue((Property)ComposerGravestoneBlock.FACING)));
        theGreatComposer.setYBodyRot(theGreatComposer.getYHeadRot());
        this.level().addFreshEntity((Entity)theGreatComposer);
    }

    private void tryToApplyLegendaryEffect() {
        Item sheetMusic = this.getSheetMusic();
        if (this.level().isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level();
        if (sheetMusic.equals(ModItems.BLUES_SHEET_MUSIC.get())) {
            if (this.ticksPlaying == 10) {
                serverLevel.setDayTime(14000L);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW_SQUID_INK, this.getX(), this.getY() + 10.0, this.getZ(), 100, 0.5, 10.0, 0.5, 0.05);
            }
        } else if (sheetMusic.equals(ModItems.BACH_AIR_SHEET_MUSIC.get())) {
            if (this.ticksPlaying == 10) {
                serverLevel.setDayTime(1000L);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW_SQUID_INK, this.getX(), this.getY() + 10.0, this.getZ(), 100, 0.5, 10.0, 0.5, 0.05);
            }
        } else if (sheetMusic.equals(ModItems.GREENSLEEVES_SHEET_MUSIC.get())) {
            if (this.ticksPlaying % 40 == 0) {
                this.applyLegendaryOrchestraEffect(serverLevel, (Holder<MobEffect>)MobEffects.HEALTH_BOOST, 4);
            }
        } else if (sheetMusic.equals(ModItems.LA_BAMBA_SHEET_MUSIC.get())) {
            if (this.ticksPlaying % 40 == 0) {
                this.applyLegendaryOrchestraEffect(serverLevel, (Holder<MobEffect>)MobEffects.LUCK, 2);
            }
        } else if (sheetMusic.equals(ModItems.JAZZY_FUR_ELISE_SHEET_MUSIC.get())) {
            if (this.ticksPlaying % 40 == 0) {
                this.applyLegendaryOrchestraEffect(serverLevel, (Holder<MobEffect>)MobEffects.SATURATION, 2);
            }
        } else if (sheetMusic.equals(ModItems.DANCE_OF_THE_LITTLE_SWANS.get())) {
            if (this.ticksPlaying % 20 == 0) {
                Player owner = this.level().getPlayerByUUID(this.getOwnerUUID());
                Monster target = (Monster)this.level().getNearestEntity(Monster.class, TargetingConditions.forCombat().range(15.0), (LivingEntity)owner, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(15.0));
                if (target != null) {
                    Vec3 direction = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0).subtract(this.position().add(0.0, 2.5, 0.0)).normalize().scale(0.35);
                    PhantomNoteProjectileEntity note = new PhantomNoteProjectileEntity((LivingEntity)this, direction, this.level());
                    note.setGood(true);
                    note.moveTo(this.getX(), this.getY() + 1.75, this.getZ());
                    note.setDeltaMovement(direction);
                    this.level().addFreshEntity((Entity)note);
                }
            }
        } else if (sheetMusic.equals(ModItems.RESURRECTION_SONG.get()) && this.ticksPlaying == 10) {
            List entities = this.level().getEntitiesOfClass(PlayerCanonEntity.class, this.getBoundingBox().inflate(64.0), entity -> entity.getOwnerUUID().equals(this.getOwnerUUID()));
            LivingEntity direction = this.getOwner();
            if (direction instanceof Player) {
                Player player = (Player)direction;
                if (entities.isEmpty()) {
                    PlayerCanonEntity playerCanon = new PlayerCanonEntity(ModEntities.PLAYER_CANON.get(), this.level());
                    playerCanon.setPos(player.position());
                    playerCanon.setConductor(this);
                    playerCanon.setOwnerUUID(player.getUUID());
                    ((CustomSimpleTrigger)((Object)ModAdvancements.PLAYER_CANON.get())).trigger((ServerPlayer)player);
                    this.level().addFreshEntity((Entity)playerCanon);
                }
            }
        }
    }

    private void applyLegendaryOrchestraEffect(ServerLevel serverLevel, Holder<MobEffect> luck, int amplifier) {
        List players = serverLevel.getPlayers(player -> player.distanceTo((Entity)this) <= 50.0f);
        for (Player player2 : players) {
            player2.addEffect(new MobEffectInstance(luck, 100, amplifier, true, true));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isTame()) {
            if (hand == InteractionHand.MAIN_HAND && this.isHoldingBaton() && !player.isSecondaryUseActive() && !this.level().isClientSide()) {
                this.openCustomMenu(player);
                return InteractionResult.SUCCESS;
            }
            if (itemStack.isEmpty() && this.isHoldingBaton() && player.isSecondaryUseActive()) {
                Item item = this.isHoldingLegendaryBaton() ? (Item)ModItems.LEGENDARY_BATON.get() : (Item)ModItems.BATON.get();
                player.setItemInHand(hand, new ItemStack((ItemLike)item, 1));
                this.setHoldingBaton(false);
                this.setLegendaryBaton(false);
                this.setOrderedToSit(false);
                return InteractionResult.SUCCESS;
            }
            if (itemStack.is(ModItems.BATON) && !this.isHoldingBaton()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, this.getX(), this.getY() + 2.5, this.getZ(), 0.0, 0.5, 0.0);
                player.setItemInHand(hand, ItemStack.EMPTY);
                this.setHoldingBaton(true);
                this.setLegendaryBaton(false);
                this.setOrderedToSit(true);
                return InteractionResult.CONSUME;
            }
            if (itemStack.is(ModItems.LEGENDARY_BATON) && !this.isHoldingBaton()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, this.getX(), this.getY() + 2.5, this.getZ(), 0.0, 0.5, 0.0);
                player.setItemInHand(hand, ItemStack.EMPTY);
                this.setHoldingBaton(true);
                this.setLegendaryBaton(true);
                this.setOrderedToSit(true);
            } else if (itemStack.is(ModItems.BRIEFCASE) && ((Boolean)itemStack.getOrDefault(ModDataComponents.OPENED, (Object)false)).booleanValue() && this.getOwnerUUID().equals(player.getUUID())) {
                ArrayList animals = (ArrayList)itemStack.get(ModDataComponents.BRIEFCASE_ANIMAL_LIST);
                if (animals == null) {
                    animals = new ArrayList(6);
                    itemStack.set(ModDataComponents.BRIEFCASE_ANIMAL_LIST, animals);
                }
                if (animals.size() < 6) {
                    if (!this.level().isClientSide()) {
                        ArrayList<String> newAnimals = new ArrayList<String>(animals);
                        newAnimals.add(MusicUtil.musicalAnimalToString((Entity)this));
                        itemStack.set(ModDataComponents.BRIEFCASE_ANIMAL_LIST, newAnimals);
                        if (newAnimals.size() == 6) {
                            itemStack.set(ModDataComponents.OPENED, (Object)false);
                        }
                        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY(), this.getZ(), 60, 0.5, 0.5, 0.5, 0.0);
                        this.discard();
                    } else {
                        this.level().playSound(player, this.blockPosition(), SoundEvents.PLAYER_TELEPORT, SoundSource.BLOCKS);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide) {
            if (this.isHoldingBaton() && this.isTame()) {
                this.setHoldingBaton(false);
                if (this.isHoldingLegendaryBaton()) {
                    this.setLegendaryBaton(false);
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(ModItems.LEGENDARY_BATON, 1)));
                } else {
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(ModItems.BATON, 1)));
                }
            }
            this.setInSittingPose(false);
        }
        return super.hurt(source, amount);
    }

    private void openCustomMenu(Player player) {
        if (!this.level().isClientSide()) {
            ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new ConductorMenu(id, playerInventory, this), this.getDisplayName()), buf -> buf.writeUUID(this.getUUID()));
        }
    }

    public boolean shouldTryTeleportToOwner() {
        return false;
    }

    private float getYRot(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
    }

    public void activateParticles(boolean particlesActivated) {
        this.particlesActivated = particlesActivated;
    }

    public boolean areParticlesActivated() {
        return this.particlesActivated;
    }

    public void setHoldingBaton(boolean holdingBaton) {
        this.entityData.set(HOLDING_BATON, (Object)holdingBaton);
    }

    public void setReady(boolean ready) {
        this.entityData.set(IS_READY, (Object)ready);
    }

    public void setMusical(boolean isMusical) {
        this.entityData.set(IS_MUSICAL, (Object)isMusical);
    }

    public boolean isMusical() {
        return (Boolean)this.entityData.get(IS_MUSICAL);
    }

    public boolean isHoldingBaton() {
        return this.holdingBaton;
    }

    public boolean isConducting() {
        return this.isConducting;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public Set<MusicalEntity> getOrchestra() {
        return this.orchestra;
    }

    public Item getSheetMusic() {
        return this.inventory.getStackInSlot(0).getItem();
    }

    public boolean isHoldingASheetMusic() {
        return !this.inventory.getStackInSlot(0).isEmpty();
    }

    public int getTicksPlaying() {
        return this.ticksPlaying;
    }

    public void setTicksPlaying(int ticksPlaying) {
        this.ticksPlaying = ticksPlaying;
    }

    public void addMusician(MusicalEntity musicalEntity) {
        this.orchestra.add(musicalEntity);
        if (!this.isConducting) {
            this.entityData.set(IS_CONDUCTING, (Object)true);
        }
        this.isConducting = true;
    }

    public void removeMusician(MusicalEntity musicalEntity) {
        this.orchestra.remove((Object)musicalEntity);
        if (this.orchestra.isEmpty()) {
            this.entityData.set(IS_CONDUCTING, (Object)false);
        }
        this.isConducting = false;
    }

    public void setConducting(boolean setConducting) {
        this.entityData.set(IS_CONDUCTING, (Object)setConducting);
        this.isConducting = setConducting;
    }

    public boolean isOrchestraEmpty() {
        return this.orchestra == null || this.orchestra.isEmpty();
    }

    public boolean isOrchestraFull() {
        return this.orchestra.size() == MusicUtil.getMaxSize(this.getSheetMusic());
    }

    public float getCurrentVolume() {
        return ((Float)this.entityData.get(VOLUME)).floatValue();
    }

    public void setCurrentVolume(float currentVolume) {
        this.entityData.set(VOLUME, (Object)Float.valueOf(currentVolume));
    }

    public boolean isMusicianApt(MusicalEntity musician) {
        return MusicUtil.getInstruments(this.getSheetMusic()).contains(musician.getInstrument().get());
    }

    public boolean isHoldingLegendaryBaton() {
        return (Boolean)this.entityData.get(IS_LEGENDARY_BATON);
    }

    public void setLegendaryBaton(boolean legendaryBaton) {
        this.entityData.set(IS_LEGENDARY_BATON, (Object)legendaryBaton);
    }
}

