/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.mixins.client.accessors.ClientLevelAccessor;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.ModTags;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;

public abstract class MusicalEntity
extends TamableAnimal {
    protected DeferredItem<Item> instrument = this.getInstrument();
    protected static final EntityDataAccessor<Boolean> HOLDING_INSTRUMENT = SynchedEntityData.defineId(MusicalEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Optional<UUID>> CONDUCTOR_ID = SynchedEntityData.defineId(MusicalEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<Boolean> IS_MUSICAL = SynchedEntityData.defineId(MusicalEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected boolean isHoldingInstrument;
    protected UUID conductorUUID = null;
    private int ticksSinceLoaded = 0;

    protected MusicalEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public abstract DeferredItem<Item> getInstrument();

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(HOLDING_INSTRUMENT, (Object)false);
        builder.define(IS_MUSICAL, (Object)false);
        builder.define(CONDUCTOR_ID, Optional.empty());
        super.defineSynchedData(builder);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (HOLDING_INSTRUMENT.equals(key)) {
            this.isHoldingInstrument = (Boolean)this.entityData.get(HOLDING_INSTRUMENT);
        }
        if (CONDUCTOR_ID.equals(key)) {
            this.conductorUUID = ((Optional)this.entityData.get(CONDUCTOR_ID)).orElse(null);
        }
        super.onSyncedDataUpdated(key);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HoldingInstrument", this.isHoldingInstrument());
        compound.putBoolean("IsMusical", this.isMusical());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(HOLDING_INSTRUMENT, (Object)compound.getBoolean("HoldingInstrument"));
        this.entityData.set(IS_MUSICAL, (Object)compound.getBoolean("IsMusical"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide && this.isHoldingInstrument() && this.isTame()) {
            this.setHoldingInstrument(false);
            this.setInSittingPose(false);
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(this.instrument, 1)));
        }
        return super.hurt(source, amount);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isTame() && this.getOwnerUUID().equals(player.getUUID())) {
            if (itemStack.is(ModTags.Items.IS_BATON) && !this.isPlayingInstrument() && itemStack.get(ModDataComponents.MUSICIAN_UUID) == null) {
                itemStack.set(ModDataComponents.MUSICIAN_UUID, (Object)this.uuid);
                return InteractionResult.SUCCESS;
            }
            if (itemStack.is(this.instrument) && !this.isHoldingInstrument()) {
                this.setHoldingInstrument(true);
                player.setItemInHand(hand, ItemStack.EMPTY);
                this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, this.getX(), this.getY() + 2.5, this.getZ(), 0.0, 0.5, 0.0);
                this.setOrderedToSit(true);
                return InteractionResult.CONSUME;
            }
            if (itemStack.isEmpty() && this.isHoldingInstrument()) {
                this.setHoldingInstrument(false);
                player.setItemInHand(hand, new ItemStack((ItemLike)this.instrument.get(), 1));
                this.setOrderedToSit(false);
                return InteractionResult.SUCCESS;
            }
            if (itemStack.is(ModItems.BRIEFCASE) && ((Boolean)itemStack.getOrDefault(ModDataComponents.OPENED, (Object)false)).booleanValue() && this.getOwnerUUID().equals(player.getUUID())) {
                ArrayList animals = (ArrayList)itemStack.get(ModDataComponents.BRIEFCASE_ANIMAL_LIST);
                if (animals == null) {
                    animals = new ArrayList(6);
                    itemStack.set(ModDataComponents.BRIEFCASE_ANIMAL_LIST, animals);
                }
                if (animals.size() < 6) {
                    if (!this.level().isClientSide()) {
                        ArrayList<String> newAnimals = new ArrayList<String>(animals);
                        newAnimals.add(MusicUtil.musicalAnimalToString((Entity)this));
                        itemStack.set(ModDataComponents.BRIEFCASE_ANIMAL_LIST, newAnimals);
                        if (newAnimals.size() == 6) {
                            itemStack.set(ModDataComponents.OPENED, (Object)false);
                        }
                        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY(), this.getZ(), 60, 0.5, 0.5, 0.5, 0.0);
                        if (this.isPlayingInstrument() && this.getConductor() != null) {
                            this.getConductor().removeMusician(this);
                        }
                        this.discard();
                    } else {
                        this.level().playSound(player, this.blockPosition(), SoundEvents.PLAYER_TELEPORT, SoundSource.BLOCKS);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.FAIL;
    }

    public void tick() {
        if (this.ticksSinceLoaded < 40) {
            ++this.ticksSinceLoaded;
        }
        super.tick();
    }

    public void tryToTame(Player player) {
        if (this.level().getRandom().nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
            this.tame(player);
            this.navigation.stop();
            this.setTarget(null);
            this.playSound(ModSounds.SUCCESSFUL_TAME.get());
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
            if (!this.level().isClientSide()) {
                ((CustomSimpleTrigger)((Object)ModAdvancements.TAME_MUSICIAN.get())).trigger((ServerPlayer)player);
            }
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public void setHoldingInstrument(boolean holdingInstrument) {
        this.entityData.set(HOLDING_INSTRUMENT, (Object)holdingInstrument);
    }

    public boolean isHoldingInstrument() {
        return this.isHoldingInstrument;
    }

    public boolean isPlayingInstrument() {
        return this.conductorUUID != null;
    }

    public void setMusical() {
        this.entityData.set(IS_MUSICAL, (Object)true);
    }

    public boolean isMusical() {
        return (Boolean)this.entityData.get(IS_MUSICAL);
    }

    @Nullable
    public ConductorEntity getConductor() {
        if (this.level().isClientSide()) {
            return this.conductorUUID == null ? null : (ConductorEntity)((ClientLevelAccessor)this.level()).callGetEntities().get(this.conductorUUID);
        }
        return this.conductorUUID == null ? null : (ConductorEntity)((ServerLevel)this.level()).getEntity(this.conductorUUID);
    }

    public boolean shouldTryTeleportToOwner() {
        return false;
    }

    public void setConductor(ConductorEntity conductor) {
        UUID conductorUUID = conductor == null ? null : conductor.getUUID();
        this.entityData.set(CONDUCTOR_ID, Optional.ofNullable(conductorUUID));
    }

    public int getTicksSinceLoaded() {
        return this.ticksSinceLoaded;
    }
}

