/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.goals.MusicalEntityPlayingInstrumentGoal;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PenguinEntity
extends MusicalEntity
implements GeoEntity {
    protected static final RawAnimation RUN = RawAnimation.begin().thenPlay("run");
    protected static final RawAnimation WADDLE = RawAnimation.begin().thenPlay("waddle");
    protected static final RawAnimation WADDLE_FLUTE = RawAnimation.begin().thenPlay("waddle_flute");
    protected static final RawAnimation WAVE = RawAnimation.begin().thenPlay("wave");
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation IDLE_FLUTE = RawAnimation.begin().thenPlay("holding_flute");
    protected static final RawAnimation PLAYING = RawAnimation.begin().thenPlay("playing");
    private static final EntityDataAccessor<Boolean> IS_RUNNING = SynchedEntityData.defineId(PenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean isRunning = false;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<PenguinEntity> penguinController = new AnimationController((GeoAnimatable)this, "penguin_controller", 5, this::penguinState).triggerableAnim("wave", WAVE);

    public PenguinEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.addOverriddenGoals();
    }

    @Override
    public DeferredItem<Item> getInstrument() {
        return ModItems.FLUTE;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MusicalEntityPlayingInstrumentGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private <E extends GeoAnimatable> PlayState penguinState(AnimationState<E> state) {
        if (this.isPlayingInstrument()) {
            state.getController().setAnimation(PLAYING);
        } else if (state.isMoving()) {
            state.getController().setAnimation(this.isHoldingInstrument() ? WADDLE_FLUTE : WADDLE);
        } else if (this.isHoldingInstrument()) {
            state.getController().setAnimation(IDLE_FLUTE);
        } else if (state.isMoving() && this.isRunning()) {
            state.getController().setAnimation(RUN);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private void addOverriddenGoals() {
        this.goalSelector.addGoal(0, (Goal)new TamableAnimal.TamableAnimalPanicGoal(this, 2.0, DamageTypeTags.PANIC_CAUSES){
            final PenguinEntity penguin;
            {
                this.penguin = (PenguinEntity)this.mob;
            }

            public void start() {
                this.penguin.setRunning(true);
                super.start();
            }

            public void stop() {
                this.penguin.setRunning(false);
                super.stop();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 6.0f){
            final PenguinEntity penguin;
            private boolean hasWaved;
            {
                this.penguin = (PenguinEntity)this.mob;
                this.hasWaved = false;
            }

            public void start() {
                this.penguin.getNavigation().moveTo(this.penguin.getX(), this.penguin.getY(), this.penguin.getZ(), 1.0);
                this.mob.getLookControl().setLookAt(this.lookAt.getX(), this.lookAt.getEyeY(), this.lookAt.getZ());
                if (!this.hasWaved) {
                    this.penguin.wave();
                    this.hasWaved = true;
                }
                super.start();
            }

            public boolean canUse() {
                return super.canUse() && this.penguin.getNavigation().isDone();
            }

            public void tick() {
                super.tick();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal(this, (PathfinderMob)this, 1.0){
            final PenguinEntity penguin;
            {
                this.penguin = (PenguinEntity)this.mob;
            }

            public boolean canUse() {
                return super.canUse() && !this.penguin.isWaving();
            }
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_RUNNING, (Object)false);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(IS_RUNNING)) {
            this.isRunning = (Boolean)this.entityData.get(IS_RUNNING);
        }
        super.onSyncedDataUpdated(key);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isPlayingInstrument() ? null : ModSounds.BABY_PENGUIN_AMBIENT.get();
    }

    public void playAmbientSound() {
        if (this.getAmbientSound() != null) {
            this.playSound(this.getAmbientSound(), 0.3f, this.getVoicePitch());
        }
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.PARROT_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.PANDA_HURT;
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound(SoundEvents.POLAR_BEAR_STEP, 0.15f, 1.0f);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void wave() {
        this.triggerAnim("penguin_controller", "wave");
    }

    public boolean isWaving() {
        return this.penguinController.isPlayingTriggeredAnimation();
    }

    public void setRunning(boolean flag) {
        this.entityData.set(IS_RUNNING, (Object)flag);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.penguinController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

