/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.List;
import net.migueel26.faunaandorchestra.entity.custom.KoalaEntity;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.custom.WiseTree;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class InstrumentItem
extends Item {
    private final SoundEvent SOUND;

    public InstrumentItem(Item.Properties properties, SoundEvent sound) {
        super(properties);
        this.SOUND = sound;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.calculateHitResult(player).getType() != HitResult.Type.ENTITY) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), this.SOUND, SoundSource.NEUTRAL, 0.5f, 0.5f + level.getRandom().nextFloat());
            player.getCooldowns().addCooldown((Item)this, 35);
            List entities = level.getEntities((Entity)player, player.getBoundingBox().inflate(10.0));
            for (Entity entity : entities) {
                KoalaEntity koala;
                MusicalEntity musicalEntity;
                if (entity instanceof MusicalEntity && (musicalEntity = (MusicalEntity)entity).isMusical() && !musicalEntity.isTame() && musicalEntity.getInstrument().asItem().equals((Object)this)) {
                    musicalEntity.tryToTame(player);
                    continue;
                }
                if (entity instanceof KoalaEntity && (koala = (KoalaEntity)entity).isKoalaSleeping()) {
                    koala.wakeUp();
                    continue;
                }
                if (!(entity instanceof WiseTree)) continue;
                WiseTree wiseTree = (WiseTree)entity;
                wiseTree.tryToWater(this);
            }
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)("tooltip." + String.valueOf(stack.getItem()))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra.shift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private HitResult calculateHitResult(Player player) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)player, entity -> !entity.isSpectator() && entity.isPickable(), (double)player.blockInteractionRange());
    }

    public SoundEvent getSound() {
        return this.SOUND;
    }
}

