/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.entity.custom.SproutlingEntity;
import net.migueel26.faunaandorchestra.entity.custom.decorative.HealthFluteEntity;
import net.migueel26.faunaandorchestra.entity.custom.projectile.PhantomNoteProjectileEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.PlayerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PanFluteItem
extends Item {
    public static final int PUSH_PARTICLES = 10;
    public static final int POWERLESS_COOLDOWN = 20;
    public static final int DEFAULT_COOLDOWN = 80;
    public static final int HEALTH_COOLDOWN = 200;
    private static final int HEALTH_ENTITIES = 5;
    public final List<String> powersString = new ArrayList<String>(List.of("notes", "push", "health", "wind", "nature"));

    public PanFluteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack flute = player.getItemInHand(usedHand);
        List powers = (List)flute.get(ModDataComponents.PAN_FLUTE_LIST);
        Integer currentSound = (Integer)flute.get(ModDataComponents.PAN_FLUTE_SOUND);
        if (Screen.hasShiftDown() && powers != null && !powers.isEmpty()) {
            if (currentSound != null) {
                currentSound = (currentSound + 1) % powers.size();
                player.displayClientMessage((Component)Component.translatable((String)("item.faunaandorchestra.pan_flute." + this.powersString.get((Integer)powers.get(currentSound) - 1))), true);
            }
            flute.set(ModDataComponents.PAN_FLUTE_SOUND, (Object)currentSound);
            level.playSound(player, player.blockPosition(), ModSounds.PAN_FLUTE_CHANGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            player.getCooldowns().addCooldown((Item)ModItems.PAN_FLUTE.get(), 20);
            return InteractionResultHolder.consume((Object)flute);
        }
        if (currentSound != null && powers != null) {
            SoundEvent fluteSound = ModSounds.PAN_FLUTE_USE.get();
            if (powers.isEmpty()) {
                player.getCooldowns().addCooldown((Item)ModItems.PAN_FLUTE.get(), 60);
            } else {
                fluteSound = PanFluteItem.getFluteSound(player, powers, currentSound, fluteSound);
                switch ((Integer)powers.get(currentSound)) {
                    case 1: {
                        this.executeNotes(level, player, usedHand);
                        break;
                    }
                    case 2: {
                        this.executePush(level, player, flute);
                        break;
                    }
                    case 3: {
                        this.executeHealth(level, player, flute);
                        break;
                    }
                    case 4: {
                        this.executeWind(level, player, flute);
                        break;
                    }
                    case 5: {
                        this.executeNature(level, player, flute);
                    }
                }
            }
            level.playSound(player, player.blockPosition(), fluteSound, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.consume((Object)flute);
        }
        return InteractionResultHolder.fail((Object)flute);
    }

    private void executeNotes(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
    }

    private void executePush(Level level, Player player, ItemStack flute) {
        List<Entity> targets = PlayerUtil.entitiesInFrontOf((Entity)player, 7.0, level, Entity.class, null);
        level.playSound(player, player.getX(), player.getY(), player.getZ(), ModSounds.PAN_FLUTE_PUSH_WIND.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
        for (Entity entity : targets) {
            Vec3 lookAngle = player.getLookAngle();
            Vec3 particleDir = player.getLookAngle().normalize().reverse().scale((double)0.45f);
            entity.setDeltaMovement(lookAngle.normalize().scale(1.5).add(0.0, 0.5, 0.0));
            if (level.isClientSide()) continue;
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.GUST, entity.getX(), entity.getY(), entity.getZ(), 8, (double)0.4f, (double)0.4f, (double)0.4f, (double)0.1f);
            Vec3 start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
            Vec3 end = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            Vec3 dir = end.subtract(start);
            double distance = dir.length();
            dir = dir.normalize();
            for (double i = 0.0; i < distance; i += 0.5) {
                double pOffset = (double)0.05f + i / 15.0;
                Vec3 pos = start.add(dir.scale(i));
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, pos.x, pos.y, pos.z, 4, pOffset, pOffset, pOffset, (double)0.01f);
            }
        }
        player.getCooldowns().addCooldown((Item)ModItems.PAN_FLUTE.get(), 80);
    }

    private void executeHealth(Level level, Player player, ItemStack flute) {
        for (int i = 0; i < 5; ++i) {
            HealthFluteEntity entity = new HealthFluteEntity((EntityType<? extends Bat>)EntityType.BAT, level);
            entity.setInvisible(true);
            entity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 100, 5, true, false, false));
            entity.setPos(player.position().add(0.0, 0.5, 0.0));
            level.addFreshEntity((Entity)entity);
        }
        player.getCooldowns().addCooldown((Item)ModItems.PAN_FLUTE.get(), 200);
    }

    private void executeWind(Level level, Player player, ItemStack flute) {
        Vec3 lookAngle = player.getLookAngle();
        level.playSound(player, player.getX(), player.getY(), player.getZ(), ModSounds.PAN_FLUTE_WIND_IMPULSE.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
        if (!level.isClientSide()) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, player.getX(), player.getY(), player.getZ(), 20, 0.1, 0.1, 0.1, 0.1);
        }
        player.setDeltaMovement(lookAngle.normalize().scale(2.0));
        player.setIgnoreFallDamageFromCurrentImpulse(true);
        player.getCooldowns().addCooldown((Item)ModItems.PAN_FLUTE.get(), 80);
    }

    private void executeNature(Level level, Player player, ItemStack flute) {
        List sproutlings = level.getEntitiesOfClass(SproutlingEntity.class, player.getBoundingBox().inflate(6.0));
        if (sproutlings.size() >= 6) {
            List choir = sproutlings.stream().limit(6L).toList();
            SproutlingEntity director = (SproutlingEntity)((Object)choir.getFirst());
            director.setDirSproutlings(sproutlings);
            director.setDirCentroid(this.getCentroid(sproutlings));
            director.setDirOwnerUUID(player.getUUID());
        }
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Integer n = PanFluteItem.getPower(stack);
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{1}, (Object)n, n2)) {
            case 0: {
                if (remainingUseDuration % 5 != 0) break;
                Player player = (Player)livingEntity;
                Vec3 vec3 = player.getViewVector(1.0f);
                Vec3 vec31 = vec3.normalize().scale(2.0);
                PhantomNoteProjectileEntity note = new PhantomNoteProjectileEntity((LivingEntity)player, vec31.normalize(), level);
                note.setGood(true);
                double rx = level.random.nextDouble() * 1.5 - 0.75;
                double ry = level.random.nextDouble() - 0.5;
                double rz = level.random.nextDouble() * 1.5 - 0.75;
                double noteX = player.getX() + vec3.x * 1.35 + rx;
                double noteY = player.getY(0.6) + ry;
                double noteZ = note.getZ() + vec3.z * 1.35 + rz;
                note.setPos(noteX, noteY, noteZ);
                if (!level.isClientSide()) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, noteX, noteY, noteZ, 15, 0.1, 0.1, 0.1, 0.05);
                }
                level.playSound(null, player.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 0.9f, 1.0f + level.random.nextFloat() / 2.0f);
                level.addFreshEntity((Entity)note);
                if (remainingUseDuration > 5) break;
                this.releaseUsing(stack, level, livingEntity, remainingUseDuration);
                break;
            }
        }
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        Player player = (Player)livingEntity;
        switch (PanFluteItem.getPower(stack)) {
            case 1: {
                player.getCooldowns().addCooldown((Item)ModItems.PAN_FLUTE.get(), 80);
                break;
            }
            default: {
                player.getCooldowns().addCooldown((Item)ModItems.PAN_FLUTE.get(), 20);
            }
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        if (stack.get(ModDataComponents.PAN_FLUTE_LIST) == null || ((List)stack.get(ModDataComponents.PAN_FLUTE_LIST)).isEmpty()) {
            return 0;
        }
        Integer n = PanFluteItem.getPower(stack);
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{1}, (Object)n, n2)) {
            case 0 -> 25;
            default -> 0;
        };
    }

    private static SoundEvent getFluteSound(Player player, List<Integer> powers, Integer currentSound, SoundEvent fluteSound) {
        return switch (powers.get(currentSound)) {
            case 1 -> ModSounds.PAN_FLUTE_NOTES.get();
            case 2 -> ModSounds.PAN_FLUTE_PUSH.get();
            case 3 -> ModSounds.PAN_FLUTE_HEALTH.get();
            case 4 -> ModSounds.PAN_FLUTE_WIND.get();
            case 5 -> ModSounds.PAN_FLUTE_NATURE.get();
            default -> ModSounds.PAN_FLUTE_USE.get();
        };
    }

    public static Integer getPower(ItemStack stack) {
        List powers = (List)stack.get(ModDataComponents.PAN_FLUTE_LIST);
        Integer currentSound = (Integer)stack.get(ModDataComponents.PAN_FLUTE_SOUND);
        return powers == null || currentSound == null ? null : (Integer)powers.get(currentSound);
    }

    private Vec3 getCentroid(List<SproutlingEntity> sproutlingEntities) {
        double n = sproutlingEntities.size();
        return new Vec3(sproutlingEntities.stream().map(Entity::getX).reduce(0.0, Double::sum) / n, sproutlingEntities.getFirst().getY(), sproutlingEntities.stream().map(Entity::getZ).reduce(0.0, Double::sum) / n);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        List powers = (List)stack.get(ModDataComponents.PAN_FLUTE_LIST);
        Integer sound = (Integer)stack.get(ModDataComponents.PAN_FLUTE_SOUND);
        if (powers != null && sound != null) {
            for (int i = 0; i < powers.size(); ++i) {
                ChatFormatting color = ChatFormatting.GRAY;
                if (sound == i) {
                    color = ChatFormatting.GOLD;
                }
                tooltipComponents.add((Component)Component.translatable((String)("item.faunaandorchestra.pan_flute." + this.powersString.get((Integer)powers.get(i) - 1))).withStyle(color));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

