/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.List;
import java.util.UUID;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.mixins.client.accessors.ClientLevelAccessor;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class WhistleItem
extends Item {
    public WhistleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        TamableAnimal animal;
        EntityHitResult entityHitResult;
        Entity entity;
        ItemStack whistle = player.getItemInHand(usedHand);
        HitResult hitResult = this.calculateHitResult(player);
        if (hitResult instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof TamableAnimal && (animal = (TamableAnimal)entity).isTame()) {
            whistle.set(ModDataComponents.MUSICIAN_UUID, (Object)animal.getUUID());
            whistle.set(ModDataComponents.FAUNA_NAME, (Object)(animal.hasCustomName() ? animal.getCustomName().getString() : animal.getName().getString()));
            level.playSound(player, player.blockPosition(), ModSounds.SUCCESSFUL_TAME.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResultHolder.consume((Object)whistle);
        }
        return super.use(level, player, usedHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack whistle = context.getItemInHand();
        Player player = context.getPlayer();
        HitResult hitResult = this.calculateHitResult(player);
        Level level = context.getLevel();
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            UUID uuid = (UUID)whistle.get(ModDataComponents.MUSICIAN_UUID);
            if (uuid != null) {
                if (!level.isClientSide()) {
                    Entity entity = ((ServerLevel)level).getEntity(uuid);
                    if (entity != null && entity.isAlive()) {
                        entity.moveTo(blockHitResult.getBlockPos().above().getCenter());
                        whistle.hurtAndBreak(1, (LivingEntity)player, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                        player.getCooldowns().addCooldown(whistle.getItem(), 400);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"item.faunaandorchestra.whistle.far_message"), true);
                    }
                } else {
                    Entity entity = (Entity)((ClientLevelAccessor)level).callGetEntities().get(uuid);
                    if (entity != null && entity.isAlive()) {
                        entity.moveTo(blockHitResult.getBlockPos().above().getCenter());
                    }
                }
            }
            level.playSound(player, player.blockPosition(), ModSounds.WHISTLE_CALL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        UUID uuid = (UUID)stack.get(ModDataComponents.MUSICIAN_UUID);
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.whistle.tooltip"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra.shift"));
        }
        if (uuid != null) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.whistle.desc").append((String)stack.get(ModDataComponents.FAUNA_NAME)).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public HitResult calculateHitResult(Player player) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)player, entity -> !entity.isSpectator() && entity.isPickable(), (double)player.blockInteractionRange());
    }
}

