/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.mixins.client;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.SoundBuffer;
import java.nio.IntBuffer;
import java.util.OptionalInt;
import net.migueel26.faunaandorchestra.mixins.client.accessors.SoundBufferAccessor;
import net.migueel26.faunaandorchestra.mixins.interfaces.IChannelMixin;
import net.migueel26.faunaandorchestra.sound.custom.InstrumentSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Channel.class})
public class MixinChannel
implements IChannelMixin {
    @Shadow
    @Final
    private int source;

    @Override
    public void faunaSetByteOffset(SoundInstance soundInstance, SoundBuffer soundBuffer, Integer sourceID) {
        OptionalInt bufferID = ((SoundBufferAccessor)soundBuffer).callGetAlBuffer();
        if (bufferID.isPresent()) {
            AL10.alSourcei((int)this.source, (int)4105, (int)bufferID.getAsInt());
            IntBuffer bytesOffset = BufferUtils.createIntBuffer((int)1);
            if (sourceID != 0) {
                AL10.alGetSourcei((int)sourceID, (int)4134, (IntBuffer)bytesOffset);
            }
            bytesOffset.rewind();
            IntBuffer actualByteOffset = BufferUtils.createIntBuffer((int)1).put(sourceID != 0 ? bytesOffset.get() : 0);
            actualByteOffset.rewind();
            AL11.alSourceiv((int)this.source, (int)4134, (IntBuffer)actualByteOffset);
            if (soundInstance instanceof InstrumentSoundInstance) {
                InstrumentSoundInstance instrumentSoundInstance = (InstrumentSoundInstance)soundInstance;
                instrumentSoundInstance.setSourceID(this.source);
            }
        }
    }

    @Override
    public void faunaSetTickOffset(SoundInstance soundInstance, SoundBuffer soundBuffer, Integer offset) {
        OptionalInt bufferID = ((SoundBufferAccessor)soundBuffer).callGetAlBuffer();
        if (bufferID.isEmpty()) {
            return;
        }
        AL10.alSourcei((int)this.source, (int)4105, (int)bufferID.getAsInt());
        int frequency = this.getBufferOf(bufferID.getAsInt(), 8193);
        int samplesToOffset = (int)((float)offset.intValue() / 20.0f * (float)frequency);
        int sizeInBytes = this.getBufferOf(bufferID.getAsInt(), 8196);
        int bitsPerSample = this.getBufferOf(bufferID.getAsInt(), 8194);
        int channels = this.getBufferOf(bufferID.getAsInt(), 8195);
        int lengthInSamples = sizeInBytes * 8 / (bitsPerSample * channels);
        IntBuffer sampleOffset = BufferUtils.createIntBuffer((int)1).put(samplesToOffset %= lengthInSamples);
        sampleOffset.rewind();
        AL11.alSourceiv((int)this.source, (int)4133, (IntBuffer)sampleOffset);
        if (soundInstance instanceof InstrumentSoundInstance) {
            InstrumentSoundInstance instrumentSoundInstance = (InstrumentSoundInstance)soundInstance;
            instrumentSoundInstance.setSourceID(this.source);
        }
    }

    @Unique
    private int getBufferOf(int buffer, int al) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGetBufferi((int)buffer, (int)al, (IntBuffer)intBuffer);
        intBuffer.rewind();
        return intBuffer.get();
    }
}

