/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleButton
extends Button {
    private boolean pressed;

    public ParticleButton(int x, int y, Component message, Button.OnPress onPress) {
        super(x, y, 11, 11, message, onPress, DEFAULT_NARRATION);
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void press(boolean pressed) {
        this.pressed = pressed;
    }

    public void onPress() {
        this.press(!this.pressed);
        super.onPress();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Icon icon = this.isMouseOver(mouseX, mouseY) ? (this.isPressed() ? Icon.PRESSED_HOVER : Icon.UNPRESSED_HOVER) : (this.isPressed() ? Icon.PRESSED : Icon.UNPRESSED);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon.sprite);
        guiGraphics.blit(icon.sprite, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, 11, 11);
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Icon {
        UNPRESSED(ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/widget/particle_button.png")),
        UNPRESSED_HOVER(ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/widget/particle_button_highlighted.png")),
        PRESSED(ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/widget/particle_button_deactivated.png")),
        PRESSED_HOVER(ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/widget/particle_button_deactivated_highlighted.png"));

        final ResourceLocation sprite;

        private Icon(ResourceLocation sprite) {
            this.sprite = sprite;
        }
    }
}

