/*
 * Decompiled with CFR 0.152.
 */
package com.keelbismark.nomorecreeperholes;

import com.keelbismark.nomorecreeperholes.NoMoreCreeperHoles;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CreeperFixCommand
implements CommandExecutor,
TabCompleter {
    private final NoMoreCreeperHoles plugin;

    public CreeperFixCommand(NoMoreCreeperHoles plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"This command can only be run by a player.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage((Component)Component.text((String)"Usage: /creeperfix <toggle|status|reload>", (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "toggle": {
                boolean currentStatus = this.plugin.isPluginEnabled();
                this.plugin.setPluginEnabled(!currentStatus);
                player.sendMessage((Component)Component.text((String)("NoMoreCreeperHoles is now " + (this.plugin.isPluginEnabled() ? "enabled" : "disabled") + "."), (TextColor)NamedTextColor.GREEN));
                break;
            }
            case "status": {
                player.sendMessage((Component)Component.text((String)("NoMoreCreeperHoles is currently " + (this.plugin.isPluginEnabled() ? "enabled" : "disabled") + "."), (TextColor)NamedTextColor.GREEN));
                break;
            }
            case "reload": {
                this.plugin.reloadConfig();
                player.sendMessage((Component)Component.text((String)"NoMoreCreeperHoles config reloaded.", (TextColor)NamedTextColor.GREEN));
                break;
            }
            default: {
                player.sendMessage((Component)Component.text((String)"Usage: /creeperfix <toggle|status|reload>", (TextColor)NamedTextColor.YELLOW));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            if ("toggle".startsWith(partial)) {
                completions.add("toggle");
            }
            if ("status".startsWith(partial)) {
                completions.add("status");
            }
            if ("reload".startsWith(partial)) {
                completions.add("reload");
            }
        }
        return completions;
    }
}

