/*
 * Decompiled with CFR 0.152.
 */
package com.keelbismark.nomorecreeperholes;

import com.keelbismark.nomorecreeperholes.NoMoreCreeperHoles;
import com.keelbismark.nomorecreeperholes.RestorationTask;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ExplosionRestoreListener
implements Listener {
    private final NoMoreCreeperHoles plugin;

    public ExplosionRestoreListener(NoMoreCreeperHoles plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        boolean shouldApply;
        EntityType entityType = event.getEntityType();
        boolean preventDrops = this.plugin.getConfig().getBoolean("prevent-drops");
        double maxRestoreRadiusSquared = Math.pow(this.plugin.getConfig().getInt("max-restore-radius"), 2.0);
        List blocksToIgnore = this.plugin.getConfig().getStringList("blocks-to-ignore");
        boolean applyToCreeper = this.plugin.getConfig().getBoolean("apply-to.creeper");
        boolean applyToTnt = this.plugin.getConfig().getBoolean("apply-to.tnt");
        boolean applyToGhast = this.plugin.getConfig().getBoolean("apply-to.ghast");
        boolean applyToWither = this.plugin.getConfig().getBoolean("apply-to.wither");
        switch (entityType) {
            case CREEPER: {
                boolean bl = applyToCreeper;
                break;
            }
            case TNT: {
                boolean bl = applyToTnt;
                break;
            }
            case GHAST: {
                boolean bl = applyToGhast;
                break;
            }
            case WITHER: {
                boolean bl = applyToWither;
                break;
            }
            default: {
                boolean bl = shouldApply = false;
            }
        }
        if (!shouldApply) {
            return;
        }
        Location explosionCenter = event.getLocation();
        if (preventDrops) {
            event.setYield(0.0f);
        }
        List affectedBlocks = event.blockList();
        affectedBlocks.removeIf(block -> block.getState() instanceof ShulkerBox);
        affectedBlocks.removeIf(block -> explosionCenter.distanceSquared(block.getLocation()) > maxRestoreRadiusSquared || blocksToIgnore.contains(block.getType().name()));
        for (Block block2 : affectedBlocks) {
            this.plugin.getRestorationManager().saveBlockForRestoration(block2.getState());
        }
        if (!affectedBlocks.isEmpty()) {
            int restoreDelay = this.plugin.getConfig().getInt("restore-delay");
            new RestorationTask(this.plugin, explosionCenter, restoreDelay).start();
        }
        this.plugin.getLogger().info("Explosion at " + String.valueOf(explosionCenter) + " processed. Blocks to restore: " + affectedBlocks.size());
    }
}

