/*
 * Decompiled with CFR 0.152.
 */
package com.keelbismark.nomorecreeperholes;

import com.keelbismark.nomorecreeperholes.NoMoreCreeperHoles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RestorationManager {
    private final NoMoreCreeperHoles plugin;
    private final Map<Location, BlockState> savedBlocks = new HashMap<Location, BlockState>();
    private final Map<Location, ItemStack[]> savedContainerContents = new HashMap<Location, ItemStack[]>();

    public RestorationManager(NoMoreCreeperHoles plugin) {
        this.plugin = plugin;
    }

    public void saveBlockForRestoration(BlockState blockState) {
        this.savedBlocks.put(blockState.getLocation(), blockState);
    }

    public void saveContainerContents(Location location, ItemStack[] contents) {
        this.savedContainerContents.put(location, contents);
    }

    public void restoreBlocks() {
        String restoreMode = this.plugin.getConfig().getString("restore-mode", "instant");
        final boolean restoreFullNBT = this.plugin.getConfig().getBoolean("restore-full-nbt", true);
        final ArrayList<BlockState> blocksToRestore = new ArrayList<BlockState>(this.savedBlocks.values());
        Collections.sort(blocksToRestore, Comparator.comparingInt(b -> b.getLocation().getBlockY()));
        if (restoreMode.equalsIgnoreCase("instant")) {
            for (BlockState state : blocksToRestore) {
                state.update(true, restoreFullNBT);
            }
            this.restoreContainerContents();
            this.clearSavedData();
        } else if (restoreMode.equalsIgnoreCase("gradual")) {
            final int packets = 20;
            new BukkitRunnable(){
                private int currentIndex = 0;

                public void run() {
                    if (this.currentIndex >= blocksToRestore.size()) {
                        RestorationManager.this.restoreContainerContents();
                        RestorationManager.this.clearSavedData();
                        this.cancel();
                        return;
                    }
                    for (int i = 0; i < packets && this.currentIndex < blocksToRestore.size(); ++i) {
                        BlockState state = (BlockState)blocksToRestore.get(this.currentIndex);
                        state.update(true, restoreFullNBT);
                        ++this.currentIndex;
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        }
    }

    private void restoreContainerContents() {
        for (Map.Entry<Location, ItemStack[]> entry : this.savedContainerContents.entrySet()) {
            Location loc = entry.getKey();
            ItemStack[] contents = entry.getValue();
            BlockState state = loc.getBlock().getState();
            if (!(state instanceof Container)) continue;
            Container container = (Container)state;
            container.getInventory().setContents(contents);
            container.update(true, true);
        }
    }

    private void clearSavedData() {
        this.savedBlocks.clear();
        this.savedContainerContents.clear();
    }
}

