/*
 * Decompiled with CFR 0.152.
 */
package com.keelbismark.nomorecreeperholes;

import com.keelbismark.nomorecreeperholes.NoMoreCreeperHoles;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RestorationTask
extends BukkitRunnable {
    private final NoMoreCreeperHoles plugin;
    private final Location explosionLocation;
    private final long restoreTimeMillis;
    private ArmorStand hologram;

    public RestorationTask(NoMoreCreeperHoles plugin, Location explosionLocation, int delaySeconds) {
        this.plugin = plugin;
        this.explosionLocation = explosionLocation.clone();
        this.restoreTimeMillis = System.currentTimeMillis() + (long)delaySeconds * 1000L;
    }

    public void run() {
        long remainingMillis = this.restoreTimeMillis - System.currentTimeMillis();
        if (remainingMillis <= 0L) {
            this.plugin.getRestorationManager().restoreBlocks();
            if (this.hologram != null && !this.hologram.isDead()) {
                this.hologram.remove();
            }
            this.cancel();
            return;
        }
        if (this.plugin.getConfig().getBoolean("show-counter")) {
            int remainingSeconds = (int)(remainingMillis / 1000L);
            if (this.hologram == null || this.hologram.isDead()) {
                this.hologram = (ArmorStand)this.explosionLocation.getWorld().spawnEntity(this.explosionLocation.clone().add(0.5, 1.5, 0.5), EntityType.ARMOR_STAND);
                this.hologram.setGravity(false);
                this.hologram.setCanPickupItems(false);
                this.hologram.setVisible(false);
                this.hologram.customName((Component)Component.text((String)("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435: " + remainingSeconds + " \u0441\u0435\u043a.")));
                this.hologram.setCustomNameVisible(true);
                this.hologram.setMetadata("NoMoreCreeperHolesHologram", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            } else {
                this.hologram.customName((Component)Component.text((String)("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435: " + remainingSeconds + " \u0441\u0435\u043a.")));
            }
        }
    }

    public void start() {
        int restoreSpeedTicks = this.plugin.getConfig().getInt("restore-speed-ticks", 20);
        this.runTaskTimer((Plugin)this.plugin, 0L, restoreSpeedTicks);
    }
}

