/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.visualjukebox;

import de.tomalbrc.visualjukebox.ModConfig;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_1799;
import net.minecraft.class_2387;
import net.minecraft.class_243;
import net.minecraft.class_2619;
import net.minecraft.class_2769;
import org.joml.Matrix4f;

public class JukeboxHolder
extends ElementHolder {
    private final ItemDisplayElement discElement;
    private long time;
    private final class_2619 jukeboxBlockEntity;
    private boolean stopped = true;

    public JukeboxHolder(class_2619 blockEntity) {
        this.jukeboxBlockEntity = blockEntity;
        this.discElement = new ItemDisplayElement();
        this.discElement.setDisplaySize(1.5f, 1.5f);
        this.discElement.setOffset(new class_243(0.0, 0.5, 0.0));
        this.addElement((VirtualElement)this.discElement);
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
        this.updateDisc();
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setItem(class_1799 itemStack) {
        if (this.discElement != null) {
            this.discElement.setItem(itemStack);
        }
    }

    private void updateDisc() {
        if (ModConfig.getInstance().staticDiscs) {
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.rotateXYZ(0.0f, 1.5707964f, 0.0f);
            float scale = 0.67f;
            matrix4f.scale(scale, scale, 2.0f);
            matrix4f.translate(-0.03125f, this.time == 0L && !this.stopped ? -0.5f : (this.stopped ? 0.0f : -0.5f), 0.0f);
            this.discElement.setTransformation(matrix4f);
        } else {
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.rotateXYZ(1.5707964f, 0.0f, (float)Math.PI / 180 * ((float)this.time * 4.0f % 360.0f));
            matrix4f.scale(0.9f, 1.3f, 1.0f);
            matrix4f.translate(-0.03125f, 0.0f, 0.0f);
            this.discElement.setTransformation(matrix4f);
        }
        this.discElement.setInterpolationDuration(this.jukeboxBlockEntity.method_54079().method_7960() ? 0 : 11);
        this.discElement.startInterpolationIfDirty();
    }

    public void tick() {
        super.tick();
        if (this.jukeboxBlockEntity.method_10997() != null && this.jukeboxBlockEntity.method_10997().method_8510() % 10L == 0L) {
            if (((Boolean)this.jukeboxBlockEntity.method_11010().method_11654((class_2769)class_2387.field_11180)).booleanValue() && this.discElement.getItem().method_7960()) {
                this.discElement.setItem(this.jukeboxBlockEntity.method_54079());
            }
            this.updateDisc();
            if (this.jukeboxBlockEntity.method_60784().method_60754()) {
                ++this.time;
            }
        }
    }

    public long getTime() {
        return this.time;
    }
}

