/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.visualjukebox;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Path CONFIG_FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("visualjukebox.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    static ModConfig instance;
    @SerializedName(value="static")
    public boolean staticDiscs = true;

    public static ModConfig getInstance() {
        if (instance == null && !ModConfig.load()) {
            ModConfig.save();
        }
        return instance;
    }

    public static boolean load() {
        if (!CONFIG_FILE_PATH.toFile().exists()) {
            instance = new ModConfig();
            try {
                if (CONFIG_FILE_PATH.toFile().createNewFile()) {
                    FileOutputStream stream = new FileOutputStream(CONFIG_FILE_PATH.toFile());
                    stream.write(gson.toJson((Object)instance).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        try {
            instance = (ModConfig)gson.fromJson((Reader)new FileReader(CONFIG_FILE_PATH.toFile()), ModConfig.class);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static void save() {
        try {
            FileOutputStream stream = new FileOutputStream(CONFIG_FILE_PATH.toFile());
            stream.write(gson.toJson((Object)instance).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

