/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.rudahee.metallics_arts.data.enums.implementations.custom_items.MetalMindEnum;
import net.rudahee.metallics_arts.data.player.poses.CustomPoses;
import net.rudahee.metallics_arts.data.providers.ModInvestedPlayerDataProvider;
import net.rudahee.metallics_arts.data.providers.ModPaintingProvider;
import net.rudahee.metallics_arts.modules.custom_block_entities.crucible_furnace.CrucibleFurnaceScreen;
import net.rudahee.metallics_arts.modules.custom_block_entities.distillery.DistilleryScreen;
import net.rudahee.metallics_arts.modules.custom_block_entities.hemalurgy_altar_block.back.HemalurgyAltarBackRenderer;
import net.rudahee.metallics_arts.modules.custom_block_entities.hemalurgy_altar_block.back.HemalurgyAltarBackScreen;
import net.rudahee.metallics_arts.modules.custom_block_entities.hemalurgy_altar_block.front.HemalurgyAltarFrontRenderer;
import net.rudahee.metallics_arts.modules.custom_block_entities.hemalurgy_altar_block.front.HemalurgyAltarFrontScreen;
import net.rudahee.metallics_arts.modules.custom_blocks.sings.WoodTypeMetal;
import net.rudahee.metallics_arts.modules.custom_entities.custom_bosses.cadmium_inquisitor.CadmiumInquisitorRenderer;
import net.rudahee.metallics_arts.modules.custom_entities.custom_bosses.iron_inquisitor.IronInquisitorRenderer;
import net.rudahee.metallics_arts.modules.custom_entities.custom_bosses.pewter_inquisitor.PewterInquisitorRenderer;
import net.rudahee.metallics_arts.modules.custom_entities.custom_bosses.steel_inquisitor.SteelInquisitorRenderer;
import net.rudahee.metallics_arts.modules.custom_entities.ferrin.brass_ferrin_entity.BrassFerrinEntityRenderer;
import net.rudahee.metallics_arts.modules.custom_items.metal_minds.render.CuriosLayerDefinitions;
import net.rudahee.metallics_arts.modules.custom_items.metal_minds.render.MetalMindModel;
import net.rudahee.metallics_arts.modules.custom_items.metal_minds.render.MetalMindRendered;
import net.rudahee.metallics_arts.modules.effects.ModEffects;
import net.rudahee.metallics_arts.modules.logic.client.ClientEventHandler;
import net.rudahee.metallics_arts.modules.logic.client.custom_guis.overlays.MetalsOverlay;
import net.rudahee.metallics_arts.setup.Registration;
import net.rudahee.metallics_arts.setup.network.ModNetwork;
import net.rudahee.metallics_arts.setup.registries.InvestedPlayerCapabilityRegister;
import net.rudahee.metallics_arts.setup.registries.ModBannersRegister;
import net.rudahee.metallics_arts.setup.registries.ModBlockEntitiesRegister;
import net.rudahee.metallics_arts.setup.registries.ModCommandsRegister;
import net.rudahee.metallics_arts.setup.registries.ModEntityTypesRegister;
import net.rudahee.metallics_arts.setup.registries.ModEventsRegister;
import net.rudahee.metallics_arts.setup.registries.ModKeyRegister;
import net.rudahee.metallics_arts.setup.registries.ModLivingEntityRegister;
import net.rudahee.metallics_arts.setup.registries.ModMenuRegister;
import net.rudahee.metallics_arts.setup.registries.ModSoundsRegister;
import net.rudahee.metallics_arts.setup.registries.ModVillagersRegister;
import net.rudahee.metallics_arts.setup.tabs.ModCreativeTabsEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.GeckoLib;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="metallics_arts")
public class MetallicsArts {
    @Generated
    private static final Logger log = LogManager.getLogger(MetallicsArts.class);
    public static final String MOD_ID = "metallics_arts";
    public static final String VERSION = "1.8.0";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"metallics_arts");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"metallics_arts");

    public MetallicsArts() {
        log.info("\n======================================================\nStarting Registration for Metallics Arts version {}\n======================================================\n\n", (Object)VERSION);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        GeckoLib.initialize();
        log.info("Starting Register: Blocks");
        BLOCKS.register(modEventBus);
        log.info("Completed Register: Blocks");
        log.info("Starting Register: Items");
        ITEMS.register(modEventBus);
        log.info("Completed Register: Items");
        Registration.register();
        log.info("Starting Listeners: Client, Setup, queueIMC, processIMC, GUIs");
        modEventBus.addListener(this::clientInit);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        modEventBus.addListener(this::onGuOverlayEvent);
        log.info("Completed Some Listeners");
        ModEffects.register(modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            log.info("Starting Listener: ClientKeys Shortcuts");
            modEventBus.addListener(ModKeyRegister::initKeys);
            log.info("Completed Listener: ClientKeys Shortcuts");
        });
        log.info("Starting Listener: Player Data");
        modEventBus.addListener(InvestedPlayerCapabilityRegister::register);
        modEventBus.addListener(this::doClientStuff);
        log.info("Completed Listener: Player Data");
        log.info("Starting Register: Entities");
        ModEntityTypesRegister.register(modEventBus);
        ModLivingEntityRegister.register(modEventBus);
        ModBlockEntitiesRegister.register(modEventBus);
        ModVillagersRegister.register(modEventBus);
        log.info("Completed Register: Entities");
        log.info("Starting Register: Menus");
        ModMenuRegister.register(modEventBus);
        log.info("Completed Register: Menus");
        log.info("Starting Register: Sounds");
        ModSoundsRegister.register(modEventBus);
        log.info("Completed Register: Sounds");
        log.info("Starting Listener: Creative Tabs");
        modEventBus.addListener(ModCreativeTabsEvents::addToMetallicsArtsTab);
        modEventBus.addListener(ModCreativeTabsEvents::addToMetallicsArtsDecorationTab);
        modEventBus.addListener(ModCreativeTabsEvents::addToCombatTab);
        modEventBus.addListener(ModCreativeTabsEvents::addToMetallicsArtsEntityTab);
        log.info("Completed Listener: Creative Tabs");
        modEventBus.addListener(this::registerLayers);
        log.info("Starting Register: Paintings & Banners");
        ModPaintingProvider.register(modEventBus);
        ModBannersRegister.register();
        log.info("Completed Register: Paintings & Banners");
        log.info("Adding mod to Minecraft's EventBus");
        MinecraftForge.EVENT_BUS.register((Object)this);
        log.info("Completed addition to EventBus");
        log.info("\n=========================================\nCompleted Registration for Metallics Arts\n=========================================\n\n");
    }

    @SubscribeEvent
    public void attachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(InvestedPlayerCapabilityRegister.IDENTIFIER, (ICapabilityProvider)new ModInvestedPlayerDataProvider());
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        log.info("Creating packets");
        ModNetwork.registerPackets();
        ModEventsRegister.register(event);
        event.enqueueWork(ModVillagersRegister::registerPOI);
        log.info("Adding wood types");
        Sheets.addWoodType((WoodType)WoodTypeMetal.IRON_TYPE);
        Sheets.addWoodType((WoodType)WoodTypeMetal.GOLD_TYPE);
        Sheets.addWoodType((WoodType)WoodTypeMetal.COPPER_TYPE);
        Sheets.addWoodType((WoodType)WoodTypeMetal.ALUMINUM_TYPE);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        CustomPoses.initializePoses();
        event.enqueueWork(() -> {});
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        log.info("Creating Curios Slots");
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("metalmind_slot").priority(1).size(4).icon(new ResourceLocation("curios:slot/metal_mind_slot")).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void processIMC(InterModProcessEvent event) {
        log.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).toList());
    }

    @SubscribeEvent
    public void onGuOverlayEvent(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("invested_overlay", (IGuiOverlay)new MetalsOverlay());
        ClientEventHandler.onRenderGameOverlay(event);
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        log.info("Adding commands");
        ModCommandsRegister.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void clientInit(FMLClientSetupEvent e) {
        log.info("[Client] Registering Client Events");
        ModEventsRegister.clientInit(e);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuRegister.CRUCIBLE_FURNACE_MENU.get()), CrucibleFurnaceScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuRegister.HEMALURGY_ALTAR_FRONT_MENU.get()), HemalurgyAltarFrontScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuRegister.HEMALURGY_ALTAR_BACK_MENU.get()), HemalurgyAltarBackScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuRegister.DISTILLERY_MENU.get()), DistilleryScreen::new);
        WoodType.m_61844_((WoodType)WoodTypeMetal.IRON_TYPE);
        WoodType.m_61844_((WoodType)WoodTypeMetal.GOLD_TYPE);
        WoodType.m_61844_((WoodType)WoodTypeMetal.COPPER_TYPE);
        WoodType.m_61844_((WoodType)WoodTypeMetal.ALUMINUM_TYPE);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntitiesRegister.SIGN_BLOCK_ENTITY.get()), SignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntitiesRegister.HEMALURGY_ALTAR_BACK_ENTITY.get()), HemalurgyAltarBackRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntitiesRegister.HEMALURGY_ALTAR_FRONT_ENTITY.get()), HemalurgyAltarFrontRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModLivingEntityRegister.BRASS_FERRIN.get()), BrassFerrinEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModLivingEntityRegister.IRON_INQUISITOR.get()), IronInquisitorRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModLivingEntityRegister.STEEL_INQUISITOR.get()), SteelInquisitorRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModLivingEntityRegister.PEWTER_INQUISITOR.get()), PewterInquisitorRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModLivingEntityRegister.CADMIUM_INQUISITOR.get()), CadmiumInquisitorRenderer::new);
        CuriosRendererRegistry.register((Item)MetalMindEnum.IRON_STEEL.getBand(), MetalMindRendered::new);
    }

    private void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions evt) {
        evt.registerLayerDefinition(CuriosLayerDefinitions.METALMIND, MetalMindModel::createLayer);
    }

    public static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> itemSupplier) {
        return ITEMS.register(name, itemSupplier);
    }

    public static <T extends Block> RegistryObject<T> registerBlockNoItem(String name, Supplier<T> blockSupplier) {
        return BLOCKS.register(name, blockSupplier);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockSupplier) {
        RegistryObject blockRegistered = MetallicsArts.registerBlockNoItem(name, blockSupplier);
        ITEMS.register(name, () -> new BlockItem((Block)blockRegistered.get(), new Item.Properties().m_41487_(64)));
        return blockRegistered;
    }

    public static <T extends Block> RegistryObject<T> registerBlockDecoration(String name, Supplier<T> blockSupplier) {
        RegistryObject blockRegistered = MetallicsArts.registerBlockNoItem(name, blockSupplier);
        ITEMS.register(name, () -> new BlockItem((Block)blockRegistered.get(), new Item.Properties().m_41487_(64)));
        return blockRegistered;
    }
}

