/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.player.data.model.body;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.rudahee.metallics_arts.data.player.data.model.SpikeEntity;
import net.rudahee.metallics_arts.data.player.data.model.body.BodyPartEntity;
import net.rudahee.metallics_arts.data.player.data.model.enums.BodyPartEnum;
import net.rudahee.metallics_arts.data.player.data.model.enums.BodySlotEnum;

public final class HeadPartEntity
extends BodyPartEntity {
    private Integer maxQtySpikes;
    private SpikeEntity SLOT_FRONT_0;
    private SpikeEntity SLOT_FRONT_1;
    private SpikeEntity SLOT_BACK_0;

    public HeadPartEntity() {
        super(BodyPartEnum.HEAD);
        this.addSpikeBySlot(null, 0, BodySlotEnum.FRONT);
        this.addSpikeBySlot(null, 1, BodySlotEnum.FRONT);
        this.addSpikeBySlot(null, 0, BodySlotEnum.BACK);
        this.setMaxQtySpikes(3);
    }

    @Override
    public void setBodyPart(BodyPartEnum bodyPart) {
        this.bodyPart = bodyPart;
    }

    @Override
    public Integer getMaxQtySpikes() {
        return this.maxQtySpikes;
    }

    @Override
    public void setMaxQtySpikes(Integer maxQtySpikes) {
        this.maxQtySpikes = maxQtySpikes;
    }

    @Override
    public Integer getActualQtySpikes() {
        return Math.toIntExact(Stream.of(this.SLOT_BACK_0, this.SLOT_FRONT_0, this.SLOT_FRONT_1).filter(Objects::nonNull).count());
    }

    @Override
    public void addSpikeBySlot(SpikeEntity entity, int slotNum, BodySlotEnum slotPos) {
        if (slotPos == BodySlotEnum.FRONT) {
            if (slotNum == 0) {
                this.SLOT_FRONT_0 = entity;
            } else if (slotNum == 1) {
                this.SLOT_FRONT_1 = entity;
            }
        } else if (slotPos == BodySlotEnum.BACK && slotNum == 0) {
            this.SLOT_BACK_0 = entity;
        }
    }

    @Override
    public void addSpikeRandom(SpikeEntity entity) {
        if (this.SLOT_BACK_0 == null) {
            this.SLOT_BACK_0 = entity;
        } else if (this.SLOT_FRONT_0 == null) {
            this.SLOT_FRONT_0 = entity;
        } else if (this.SLOT_FRONT_1 == null) {
            this.SLOT_FRONT_1 = entity;
        } else {
            System.out.println("No se agrego la entidad " + String.valueOf(entity) + " \n EN HEAD");
        }
    }

    @Override
    public SpikeEntity getSpikeBySlot(int slotNum, BodySlotEnum slotPos) {
        if (slotPos == BodySlotEnum.FRONT) {
            if (slotNum == 0) {
                return this.SLOT_FRONT_0;
            }
            if (slotNum == 1) {
                return this.SLOT_FRONT_1;
            }
        } else if (slotPos == BodySlotEnum.BACK && slotNum == 0) {
            return this.SLOT_BACK_0;
        }
        return null;
    }

    @Override
    public List<SpikeEntity> getAllSpikes() {
        return Stream.of(this.SLOT_BACK_0, this.SLOT_FRONT_0, this.SLOT_FRONT_1).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public HashMap<String, SpikeEntity> getAllSpikesBySlotAndNum() {
        HashMap<String, SpikeEntity> spikesBySlotAndNum = new HashMap<String, SpikeEntity>();
        spikesBySlotAndNum.put("HEAD_FRONT_0", this.SLOT_FRONT_0);
        spikesBySlotAndNum.put("HEAD_FRONT_1", this.SLOT_FRONT_1);
        spikesBySlotAndNum.put("HEAD_BACK_0", this.SLOT_BACK_0);
        return spikesBySlotAndNum;
    }

    @Override
    public void removeSpikeBySlot(int slotNum, BodySlotEnum slotPos) {
        if (slotPos == BodySlotEnum.FRONT) {
            if (slotNum == 0) {
                this.SLOT_FRONT_0 = null;
            } else if (slotNum == 1) {
                this.SLOT_FRONT_1 = null;
            }
        } else if (slotPos == BodySlotEnum.BACK && slotNum == 0) {
            this.SLOT_BACK_0 = null;
        }
    }

    @Override
    public void removeSpikeBySpikeEntity(SpikeEntity entity) {
        if (entity.equals(this.SLOT_FRONT_0)) {
            this.SLOT_FRONT_0 = null;
        } else if (entity.equals(this.SLOT_FRONT_1)) {
            this.SLOT_FRONT_1 = null;
        } else if (entity.equals(this.SLOT_BACK_0)) {
            this.SLOT_BACK_0 = null;
        }
    }

    @Override
    public String toString() {
        return "HeadPartEntity{maxQtySpikes=" + this.maxQtySpikes + ", SLOT_FRONT_0=" + String.valueOf(this.SLOT_FRONT_0) + ", SLOT_FRONT_1=" + String.valueOf(this.SLOT_FRONT_1) + ", SLOT_BACK_0=" + String.valueOf(this.SLOT_BACK_0) + ", bodyPart=" + String.valueOf((Object)this.bodyPart) + "}";
    }
}

