/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.providers;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.datagen.BookLangHelper;
import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryLocationHelper;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmithingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import java.util.ArrayList;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.LanguageProvider;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.multi_craft.MultiCraftData;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.sub_division.SubdivisionData;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.sub_division.SubdivisionDescription;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.weapons.WeaponsData;
import net.rudahee.metallics_arts.utils.GetItemsUtils;

public class MetallicsArtsGuideBookProvider
extends BookProvider {
    public MetallicsArtsGuideBookProvider(DataGenerator generator, String modid, LanguageProvider lang) {
        super(generator.getPackOutput(), modid, lang);
    }

    private BookModel makeDemoBook(String bookName) {
        BookLangHelper helper = ModonomiconAPI.get().getLangHelper(this.modid);
        helper.book(bookName);
        BookCategoryModel introCategory = this.introCategory(helper);
        BookCategoryModel allomancyCategory = this.allomancyCategory(helper);
        BookCategoryModel feruchemyCategory = this.feruchemyCategory(helper);
        return BookModel.create((ResourceLocation)this.modLoc(bookName), (String)helper.bookName()).withTooltip(helper.bookTooltip()).withGenerateBookItem(true).withModel(this.modLoc("metallics_arts_book")).withCreativeTab(new ResourceLocation("metallics_arts", "metallics_arts_tab")).withCategories(new BookCategoryModel[]{introCategory, allomancyCategory, feruchemyCategory});
    }

    private BookCategoryModel introCategory(BookLangHelper helper) {
        helper.category("intro");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"_________g___________t__f_______", "________________________________", "_______d____a_____p_____________", "________________________________", "_________h___________r__e_______", "_______________s________________", "________________________________", "_______________b________________", "_________n___________k__________", "____________j_____i_____________", "_________o_____m_____l__________", "________________________________"});
        BookEntryModel welcome = this.welcomePowerEntry(helper, entryHelper, 's', SubdivisionData.WELCOME);
        BookEntryModel weapons = this.subDivisionEntry(helper, entryHelper, 'a', SubdivisionData.WEAPONS, welcome);
        BookEntryModel crafting = this.subDivisionEntry(helper, entryHelper, 'b', SubdivisionData.CAFTING, welcome);
        BookEntryModel cores = this.multiCraftsItemsEntry(helper, entryHelper, 'p', MultiCraftData.CORES, GetItemsUtils.getCores(), welcome);
        BookEntryModel aluminum_armor = this.multiSmithingItemsEntry(helper, entryHelper, 'r', MultiCraftData.ALUMINUM_ARMOR, GetItemsUtils.getAluminumArmor(), cores);
        BookEntryModel steel_armor = this.multiSmithingItemsEntry(helper, entryHelper, 't', MultiCraftData.STEEL_ARMOR, GetItemsUtils.getSteelArmor(), cores);
        BookEntryModel crystalDagger = this.weaponsEntry(helper, entryHelper, 'd', weapons, WeaponsData.SILVER_KNIFE);
        BookEntryModel obsidianDagger = this.weaponsEntry(helper, entryHelper, 'e', aluminum_armor, WeaponsData.OBSIDIAN_DAGGER);
        BookEntryModel obsidianAxe = this.weaponsEntry(helper, entryHelper, 'f', steel_armor, WeaponsData.OBSIDIAN_AXE);
        BookEntryModel kolossBlade = this.weaponsEntry(helper, entryHelper, 'g', weapons, WeaponsData.KOLOSS_BLADE);
        BookEntryModel duelingStaff = this.weaponsEntry(helper, entryHelper, 'h', weapons, WeaponsData.DUELING_STAFF);
        BookEntryModel vials = this.multiCraftsItemsEntry(helper, entryHelper, 'j', MultiCraftData.VIALS, GetItemsUtils.getVialsList(), crafting);
        BookEntryModel rings = this.multiCraftsItemsEntry(helper, entryHelper, 'k', MultiCraftData.RINGS, GetItemsUtils.getRingList(), crafting);
        BookEntryModel bands = this.multiCraftsItemsEntry(helper, entryHelper, 'l', MultiCraftData.BANDS, GetItemsUtils.getBandList(), rings);
        BookEntryModel spikes = this.multiCraftsItemsEntry(helper, entryHelper, 'm', MultiCraftData.SPIKES, GetItemsUtils.getSpikesList(), crafting);
        BookEntryModel icons = this.multiCraftsItemsEntry(helper, entryHelper, 'n', MultiCraftData.ICONS, GetItemsUtils.getIconsList(), crafting);
        BookEntryModel alloys = this.multiCraftsItemsEntry(helper, entryHelper, 'i', MultiCraftData.ALLOYS, GetItemsUtils.getAlloysList(), crafting);
        BookEntryModel patterns = this.multiCraftsItemsEntry(helper, entryHelper, 'o', MultiCraftData.PATTERNS, GetItemsUtils.getPatterns(), icons);
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("minecraft:book").withSortNumber(0).withEntries(new BookEntryModel[]{weapons, crafting, crystalDagger, obsidianDagger, obsidianAxe, kolossBlade, duelingStaff, alloys, vials, rings, bands, spikes, icons, patterns, welcome, cores, aluminum_armor, steel_armor});
    }

    private BookCategoryModel allomancyCategory(BookLangHelper helper) {
        helper.category("allomancy");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"________i______B______a________", "_______j_______________b_______", "___________q_______r___________", "_______k_______________c_______", "________l_____________d________", "_______________s_______________", "________m_____________e________", "_______n_______________f_______", "___________t_______v___________", "_______o_______________g_______", "________p______A______h________", "__________w_________z__________", "_____________x___y______________"});
        BookEntryModel allomancy = this.welcomePowerEntry(helper, entryHelper, 's', SubdivisionData.ALLOMANCY);
        BookEntryModel physical = this.subDivisionEntry(helper, entryHelper, 'r', SubdivisionData.PHYSICAL_ALLOMANCY, allomancy);
        BookEntryModel enhancement = this.subDivisionEntry(helper, entryHelper, 't', SubdivisionData.ENHANCEMENT, allomancy);
        BookEntryModel temporal = this.subDivisionEntry(helper, entryHelper, 'v', SubdivisionData.TEMPORAL, allomancy);
        BookEntryModel cognitive = this.subDivisionEntry(helper, entryHelper, 'q', SubdivisionData.MENTAL, allomancy);
        BookEntryModel divine = this.subDivisionEntry(helper, entryHelper, 'A', SubdivisionData.DIVINE_ALLOMANCY, allomancy);
        BookEntryModel tutorial = this.subDivisionEntry(helper, entryHelper, 'B', SubdivisionData.TUTORIAL_ALLOMANCY, allomancy);
        BookEntryModel iron = this.allomancyPowerEntry(helper, entryHelper, 'a', MetalTagEnum.IRON, physical);
        BookEntryModel steel = this.allomancyPowerEntry(helper, entryHelper, 'b', MetalTagEnum.STEEL, physical);
        BookEntryModel tin = this.allomancyPowerEntry(helper, entryHelper, 'c', MetalTagEnum.TIN, physical);
        BookEntryModel pewter = this.allomancyPowerEntry(helper, entryHelper, 'd', MetalTagEnum.PEWTER, physical);
        BookEntryModel gold = this.allomancyPowerEntry(helper, entryHelper, 'e', MetalTagEnum.GOLD, temporal);
        BookEntryModel electrum = this.allomancyPowerEntry(helper, entryHelper, 'f', MetalTagEnum.ELECTRUM, temporal);
        BookEntryModel cadmium = this.allomancyPowerEntry(helper, entryHelper, 'g', MetalTagEnum.CADMIUM, temporal);
        BookEntryModel bendalloy = this.allomancyPowerEntry(helper, entryHelper, 'h', MetalTagEnum.BENDALLOY, temporal);
        BookEntryModel copper = this.allomancyPowerEntry(helper, entryHelper, 'i', MetalTagEnum.COPPER, cognitive);
        BookEntryModel bronze = this.allomancyPowerEntry(helper, entryHelper, 'j', MetalTagEnum.BRONZE, cognitive);
        BookEntryModel zinc = this.allomancyPowerEntry(helper, entryHelper, 'k', MetalTagEnum.ZINC, cognitive);
        BookEntryModel brass = this.allomancyPowerEntry(helper, entryHelper, 'l', MetalTagEnum.BRASS, cognitive);
        BookEntryModel aluminum = this.allomancyPowerEntry(helper, entryHelper, 'm', MetalTagEnum.ALUMINUM, enhancement);
        BookEntryModel duralumin = this.allomancyPowerEntry(helper, entryHelper, 'n', MetalTagEnum.DURALUMIN, enhancement);
        BookEntryModel chromium = this.allomancyPowerEntry(helper, entryHelper, 'o', MetalTagEnum.CHROMIUM, enhancement);
        BookEntryModel nicrosil = this.allomancyPowerEntry(helper, entryHelper, 'p', MetalTagEnum.NICROSIL, enhancement);
        BookEntryModel atium = this.allomancyPowerEntry(helper, entryHelper, 'w', MetalTagEnum.ATIUM, divine);
        BookEntryModel malatium = this.allomancyPowerEntry(helper, entryHelper, 'x', MetalTagEnum.MALATIUM, divine);
        BookEntryModel lerasium = this.allomancyPowerEntry(helper, entryHelper, 'y', MetalTagEnum.LERASIUM, divine);
        BookEntryModel ettmetal = this.allomancyPowerEntry(helper, entryHelper, 'z', MetalTagEnum.ETTMETAL, divine);
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("minecraft:iron_ingot").withSortNumber(1).withEntries(new BookEntryModel[]{iron, steel, tin, pewter, gold, electrum, cadmium, bendalloy, copper, bronze, zinc, brass, aluminum, duralumin, chromium, nicrosil, cognitive, physical, allomancy, enhancement, temporal, atium, malatium, lerasium, ettmetal, divine, tutorial});
    }

    private BookCategoryModel feruchemyCategory(BookLangHelper helper) {
        helper.category("feruchemy");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap(new String[]{"________i______B______a________", "_______j_______________b_______", "___________q_______r___________", "_______k_______________c_______", "________l_____________d________", "_______________s_______________", "________m_____________e________", "_______n_______________f_______", "___________t_______v___________", "_______o_______________g_______", "________p______A______h________", "__________w_________z__________", "_____________x___y______________"});
        BookEntryModel feruchemy = this.welcomePowerEntry(helper, entryHelper, 's', SubdivisionData.FERUCHEMY);
        BookEntryModel physical = this.subDivisionEntry(helper, entryHelper, 'r', SubdivisionData.PHYSICAL_FERUCHEMY, feruchemy);
        BookEntryModel spiritual = this.subDivisionEntry(helper, entryHelper, 't', SubdivisionData.SPIRITUAL, feruchemy);
        BookEntryModel hybrid = this.subDivisionEntry(helper, entryHelper, 'v', SubdivisionData.HYBRID, feruchemy);
        BookEntryModel cognitive = this.subDivisionEntry(helper, entryHelper, 'q', SubdivisionData.COGNITIVE, feruchemy);
        BookEntryModel divine = this.subDivisionEntry(helper, entryHelper, 'A', SubdivisionData.DIVINE_FERUCHEMY, feruchemy);
        BookEntryModel tutorial = this.subDivisionEntry(helper, entryHelper, 'B', SubdivisionData.TUTORIAL_FERUCHEMY, feruchemy);
        BookEntryModel iron = this.feruchemyPowerEntry(helper, entryHelper, 'a', MetalTagEnum.IRON, physical);
        BookEntryModel steel = this.feruchemyPowerEntry(helper, entryHelper, 'b', MetalTagEnum.STEEL, physical);
        BookEntryModel tin = this.feruchemyPowerEntry(helper, entryHelper, 'c', MetalTagEnum.TIN, physical);
        BookEntryModel pewter = this.feruchemyPowerEntry(helper, entryHelper, 'd', MetalTagEnum.PEWTER, physical);
        BookEntryModel gold = this.feruchemyPowerEntry(helper, entryHelper, 'e', MetalTagEnum.GOLD, hybrid);
        BookEntryModel electrum = this.feruchemyPowerEntry(helper, entryHelper, 'f', MetalTagEnum.ELECTRUM, hybrid);
        BookEntryModel cadmium = this.feruchemyPowerEntry(helper, entryHelper, 'g', MetalTagEnum.CADMIUM, hybrid);
        BookEntryModel bendalloy = this.feruchemyPowerEntry(helper, entryHelper, 'h', MetalTagEnum.BENDALLOY, hybrid);
        BookEntryModel copper = this.feruchemyPowerEntry(helper, entryHelper, 'i', MetalTagEnum.COPPER, cognitive);
        BookEntryModel bronze = this.feruchemyPowerEntry(helper, entryHelper, 'j', MetalTagEnum.BRONZE, cognitive);
        BookEntryModel zinc = this.feruchemyPowerEntry(helper, entryHelper, 'k', MetalTagEnum.ZINC, cognitive);
        BookEntryModel brass = this.feruchemyPowerEntry(helper, entryHelper, 'l', MetalTagEnum.BRASS, cognitive);
        BookEntryModel aluminum = this.feruchemyPowerEntry(helper, entryHelper, 'm', MetalTagEnum.ALUMINUM, spiritual);
        BookEntryModel duralumin = this.feruchemyPowerEntry(helper, entryHelper, 'n', MetalTagEnum.DURALUMIN, spiritual);
        BookEntryModel chromium = this.feruchemyPowerEntry(helper, entryHelper, 'o', MetalTagEnum.CHROMIUM, spiritual);
        BookEntryModel nicrosil = this.feruchemyPowerEntry(helper, entryHelper, 'p', MetalTagEnum.NICROSIL, spiritual);
        BookEntryModel atium = this.feruchemyPowerEntry(helper, entryHelper, 'w', MetalTagEnum.ATIUM, divine);
        BookEntryModel malatium = this.feruchemyPowerEntry(helper, entryHelper, 'x', MetalTagEnum.MALATIUM, divine);
        BookEntryModel lerasium = this.feruchemyPowerEntry(helper, entryHelper, 'y', MetalTagEnum.LERASIUM, divine);
        BookEntryModel ettmetal = this.feruchemyPowerEntry(helper, entryHelper, 'z', MetalTagEnum.ETTMETAL, divine);
        return BookCategoryModel.create((ResourceLocation)this.modLoc(helper.category), (String)helper.categoryName()).withIcon("minecraft:gold_ingot").withSortNumber(2).withEntries(new BookEntryModel[]{iron, steel, tin, pewter, gold, electrum, cadmium, bendalloy, copper, bronze, zinc, brass, aluminum, duralumin, chromium, nicrosil, cognitive, physical, feruchemy, spiritual, hybrid, atium, malatium, lerasium, ettmetal, divine, tutorial});
    }

    private BookEntryModel multiCraftsItemsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char location, MultiCraftData multiCraftEntry, ArrayList<String> recipeList, BookEntryModel parent) {
        helper.entry(multiCraftEntry.getId() + "_entry");
        ArrayList<Object> list = new ArrayList<Object>();
        helper.page("items_description");
        BookTextPageModel page = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        list.add(page);
        while (!recipeList.isEmpty()) {
            if (recipeList.size() != 1) {
                list.add(((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(recipeList.remove(0))).withRecipeId2(recipeList.remove(0))).build());
                continue;
            }
            list.add(((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(recipeList.remove(0))).build());
        }
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(multiCraftEntry.getIcon()).withLocation(entryHelper.get(Character.valueOf(location))).withParent(parent).withPages(list.toArray(new BookPageModel[0])).build();
    }

    private BookEntryModel multiSmithingItemsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char location, MultiCraftData multiCraftEntry, ArrayList<String> recipeList, BookEntryModel parent) {
        helper.entry(multiCraftEntry.getId() + "_entry");
        ArrayList<Object> list = new ArrayList<Object>();
        helper.page("items_description");
        BookTextPageModel page = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        list.add(page);
        while (!recipeList.isEmpty()) {
            if (recipeList.size() != 1) {
                list.add(((BookSmithingRecipePageModel.Builder)((BookSmithingRecipePageModel.Builder)BookSmithingRecipePageModel.builder().withRecipeId1(recipeList.remove(0))).withRecipeId2(recipeList.remove(0))).build());
                continue;
            }
            list.add(((BookSmithingRecipePageModel.Builder)BookSmithingRecipePageModel.builder().withRecipeId1(recipeList.remove(0))).build());
        }
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(multiCraftEntry.getIcon()).withLocation(entryHelper.get(Character.valueOf(location))).withParent(parent).withPages(list.toArray(new BookPageModel[0])).build();
    }

    private BookEntryModel weaponsEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char location, BookEntryModel parent, WeaponsData weaponsEntry) {
        helper.entry(weaponsEntry.getId() + "_entry");
        helper.page("weapon_description");
        BookTextPageModel page = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("weapon_craft");
        BookCraftingRecipePageModel page2 = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(weaponsEntry.getRecipe())).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(weaponsEntry.getIcon()).withLocation(entryHelper.get(Character.valueOf(location))).withParent(parent).withPages(new BookPageModel[]{page, page2}).build();
    }

    private BookEntryModel subDivisionEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char location, SubdivisionData subdivisionEntry, BookEntryModel parent) {
        helper.entry(subdivisionEntry.getId() + "_entry");
        ArrayList<BookTextPageModel> list = new ArrayList<BookTextPageModel>();
        int x = 1;
        for (String ignored : SubdivisionDescription.valueOf(subdivisionEntry.name()).getSpanish()) {
            helper.page("page" + x);
            BookTextPageModel page = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
            list.add(page);
            ++x;
        }
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon(subdivisionEntry.getIcon()).withLocation(entryHelper.get(Character.valueOf(location))).withParent(parent).withPages(list.toArray(new BookPageModel[0])).build();
    }

    private BookEntryModel allomancyPowerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char location, MetalTagEnum metal, BookEntryModel parent) {
        helper.entry(metal.getNameLower() + "_entry");
        helper.page("power_description");
        BookTextPageModel page = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("power_interactions");
        BookTextPageModel page2 = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("metallics_arts:" + metal.getNameLower() + "_allomantic_icon").withLocation(entryHelper.get(Character.valueOf(location))).withParent(parent).withPages(new BookPageModel[]{page, page2}).build();
    }

    private BookEntryModel feruchemyPowerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char location, MetalTagEnum metal, BookEntryModel parent) {
        helper.entry(metal.getNameLower() + "_entry");
        helper.page("power_storage");
        BookTextPageModel page = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("power_tap");
        BookTextPageModel page2 = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("metallics_arts:" + metal.getNameLower() + "_feruchemic_icon").withLocation(entryHelper.get(Character.valueOf(location))).withParent(parent).withPages(new BookPageModel[]{page, page2}).build();
    }

    private BookEntryModel welcomePowerEntry(BookLangHelper helper, EntryLocationHelper entryHelper, char location, SubdivisionData subdivisionData) {
        helper.entry(subdivisionData.getId() + "_entry");
        ArrayList<BookTextPageModel> list = new ArrayList<BookTextPageModel>();
        int x = 1;
        for (String ignored : SubdivisionDescription.valueOf(subdivisionData.name()).getSpanish()) {
            helper.page("page" + x);
            BookTextPageModel page = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
            list.add(page);
            ++x;
        }
        return BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:paper").withLocation(entryHelper.get(Character.valueOf(location))).withPages(list.toArray(new BookPageModel[0])).build();
    }

    protected void generate() {
        BookModel demoBook = this.makeDemoBook("metallics_arts_book");
        this.add(demoBook);
    }
}

