/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.providers;

import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.rudahee.metallics_arts.data.enums.implementations.GemsEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalEnum;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.setup.registries.ModBlocksRegister;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "metallics_arts", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        ModBlocksRegister.BLOCK_GEMS_BLOCKS.forEach((name, block) -> {
            ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(this.modLoc("block/" + name + "_block"));
            this.simpleBlock((Block)block);
            this.simpleBlockItem((Block)block, (ModelFile)model);
        });
        ModBlocksRegister.BLOCK_METAL_ORES.forEach((name, block) -> {
            ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(this.modLoc("block/" + name + "_ore"));
            this.simpleBlock((Block)block);
            this.simpleBlockItem((Block)block, (ModelFile)model);
        });
        ModBlocksRegister.BLOCK_METAL_DEEPSLATE_ORES.forEach((name, block) -> {
            ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(this.modLoc("block/deepslate_" + name + "_ore"));
            this.simpleBlock((Block)block);
            this.simpleBlockItem((Block)block, (ModelFile)model);
        });
        ModBlocksRegister.BLOCK_METAL_BLOCKS.forEach((name, block) -> {
            ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(this.modLoc("block/" + name + "_block"));
            this.simpleBlock((Block)block);
            this.simpleBlockItem((Block)block, (ModelFile)model);
        });
        ModBlocksRegister.RAW_METAL_BLOCKS.forEach((name, block) -> {
            ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(this.modLoc("block/raw_" + name + "_block"));
            this.simpleBlock((Block)block);
            this.simpleBlockItem((Block)block, (ModelFile)model);
        });
        ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(this.modLoc("block/budding_atium"));
        this.simpleBlock((Block)ModBlocksRegister.BUDDING_ATIUM.get());
        this.simpleBlockItem((Block)ModBlocksRegister.BUDDING_ATIUM.get(), (ModelFile)model);
        model = new ModelFile.UncheckedModelFile(this.modLoc("block/budding_lerasium"));
        this.simpleBlock((Block)ModBlocksRegister.BUDDING_LERASIUM.get());
        this.simpleBlockItem((Block)ModBlocksRegister.BUDDING_LERASIUM.get(), (ModelFile)model);
        model = new ModelFile.UncheckedModelFile(this.modLoc("block/budding_ettmetal"));
        this.simpleBlock((Block)ModBlocksRegister.BUDDING_ETTMETAL.get());
        this.simpleBlockItem((Block)ModBlocksRegister.BUDDING_ETTMETAL.get(), (ModelFile)model);
        model = new ModelFile.UncheckedModelFile(this.modLoc("block/atium_cristal_block"));
        this.simpleBlock(ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.get(MetalTagEnum.ATIUM.getGemNameLower()));
        this.simpleBlockItem(ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.get(MetalTagEnum.ATIUM.getGemNameLower()), (ModelFile)model);
        model = new ModelFile.UncheckedModelFile(this.modLoc("block/lerasium_cristal_block"));
        this.simpleBlock(ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.get(MetalTagEnum.LERASIUM.getGemNameLower()));
        this.simpleBlockItem(ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.get(MetalTagEnum.LERASIUM.getGemNameLower()), (ModelFile)model);
        model = new ModelFile.UncheckedModelFile(this.modLoc("block/ettmetal_cristal_block"));
        this.simpleBlock(ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.get(MetalTagEnum.ETTMETAL.getGemNameLower()));
        this.simpleBlockItem(ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.get(MetalTagEnum.ETTMETAL.getGemNameLower()), (ModelFile)model);
        for (MetalEnum metalEnum : MetalEnum.values()) {
            this.stairsBlock((StairBlock)ModBlocksRegister.BLOCK_METAL_STAIRS.get(metalEnum.getMetalNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            this.slabBlock((SlabBlock)ModBlocksRegister.BLOCK_METAL_SLAB.get(metalEnum.getMetalNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_METAL_BLOCKS.get(metalEnum.getMetalNameLower())), this.blockTexture(ModBlocksRegister.BLOCK_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get(metalEnum.getMetalNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get(metalEnum.getMetalNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(metalEnum.getMetalNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            if (metalEnum.isAlloy().booleanValue()) continue;
            this.stairsBlock((StairBlock)ModBlocksRegister.BLOCK_METAL_STAIRS.get(metalEnum.getMetalNameLower() + "_raw"), this.blockTexture(ModBlocksRegister.RAW_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            this.slabBlock((SlabBlock)ModBlocksRegister.BLOCK_METAL_SLAB.get(metalEnum.getMetalNameLower() + "_raw"), this.blockTexture(ModBlocksRegister.RAW_METAL_BLOCKS.get(metalEnum.getMetalNameLower())), this.blockTexture(ModBlocksRegister.RAW_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get(metalEnum.getMetalNameLower() + "_raw"), this.blockTexture(ModBlocksRegister.RAW_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get(metalEnum.getMetalNameLower() + "_raw"), this.blockTexture(ModBlocksRegister.RAW_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
            this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(metalEnum.getMetalNameLower() + "_raw"), this.blockTexture(ModBlocksRegister.RAW_METAL_BLOCKS.get(metalEnum.getMetalNameLower())));
        }
        for (Enum enum_ : GemsEnum.values()) {
            this.stairsBlock((StairBlock)ModBlocksRegister.BLOCK_METAL_STAIRS.get(((GemsEnum)enum_).getGemNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_GEMS_BLOCKS.get(((GemsEnum)enum_).getGemNameLower())));
            this.slabBlock((SlabBlock)ModBlocksRegister.BLOCK_METAL_SLAB.get(((GemsEnum)enum_).getGemNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_GEMS_BLOCKS.get(((GemsEnum)enum_).getGemNameLower())), this.blockTexture(ModBlocksRegister.BLOCK_GEMS_BLOCKS.get(((GemsEnum)enum_).getGemNameLower())));
            this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get(((GemsEnum)enum_).getGemNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_GEMS_BLOCKS.get(((GemsEnum)enum_).getGemNameLower())));
            this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get(((GemsEnum)enum_).getGemNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_GEMS_BLOCKS.get(((GemsEnum)enum_).getGemNameLower())));
            this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(((GemsEnum)enum_).getGemNameLower()), this.blockTexture(ModBlocksRegister.BLOCK_GEMS_BLOCKS.get(((GemsEnum)enum_).getGemNameLower())));
        }
        this.stairsBlock((StairBlock)ModBlocksRegister.BLOCK_METAL_STAIRS.get("iron"), this.blockTexture(Blocks.f_50075_));
        this.stairsBlock((StairBlock)ModBlocksRegister.BLOCK_METAL_STAIRS.get("gold"), this.blockTexture(Blocks.f_50074_));
        this.stairsBlock((StairBlock)ModBlocksRegister.BLOCK_METAL_STAIRS.get("iron_raw"), this.blockTexture(Blocks.f_152598_));
        this.stairsBlock((StairBlock)ModBlocksRegister.BLOCK_METAL_STAIRS.get("gold_raw"), this.blockTexture(Blocks.f_152600_));
        this.stairsBlock((StairBlock)ModBlocksRegister.BLOCK_METAL_STAIRS.get("copper_raw"), this.blockTexture(Blocks.f_152599_));
        this.slabBlock((SlabBlock)ModBlocksRegister.BLOCK_METAL_SLAB.get("gold"), this.blockTexture(Blocks.f_50074_), this.blockTexture(Blocks.f_50074_));
        this.slabBlock((SlabBlock)ModBlocksRegister.BLOCK_METAL_SLAB.get("iron"), this.blockTexture(Blocks.f_50075_), this.blockTexture(Blocks.f_50075_));
        this.slabBlock((SlabBlock)ModBlocksRegister.BLOCK_METAL_SLAB.get("gold_raw"), this.blockTexture(Blocks.f_152600_), this.blockTexture(Blocks.f_152600_));
        this.slabBlock((SlabBlock)ModBlocksRegister.BLOCK_METAL_SLAB.get("iron_raw"), this.blockTexture(Blocks.f_152598_), this.blockTexture(Blocks.f_152598_));
        this.slabBlock((SlabBlock)ModBlocksRegister.BLOCK_METAL_SLAB.get("copper_raw"), this.blockTexture(Blocks.f_152599_), this.blockTexture(Blocks.f_152599_));
        this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get("iron"), this.blockTexture(Blocks.f_50075_));
        this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get("gold"), this.blockTexture(Blocks.f_50074_));
        this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get("copper"), this.blockTexture(Blocks.f_152504_));
        this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get("iron_raw"), this.blockTexture(Blocks.f_152598_));
        this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get("gold_raw"), this.blockTexture(Blocks.f_152600_));
        this.wallBlock((WallBlock)ModBlocksRegister.BLOCK_METAL_WALL.get("copper_raw"), this.blockTexture(Blocks.f_152599_));
        this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get("iron"), this.blockTexture(Blocks.f_50075_));
        this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get("gold"), this.blockTexture(Blocks.f_50074_));
        this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get("copper"), this.blockTexture(Blocks.f_152504_));
        this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get("iron_raw"), this.blockTexture(Blocks.f_152598_));
        this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get("gold_raw"), this.blockTexture(Blocks.f_152600_));
        this.fenceBlock((FenceBlock)ModBlocksRegister.BLOCK_METAL_FENCE.get("copper_raw"), this.blockTexture(Blocks.f_152599_));
        this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get("iron"), this.blockTexture(Blocks.f_50075_));
        this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get("gold"), this.blockTexture(Blocks.f_50074_));
        this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get("copper"), this.blockTexture(Blocks.f_152504_));
        this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get("iron_raw"), this.blockTexture(Blocks.f_152598_));
        this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get("gold_raw"), this.blockTexture(Blocks.f_152600_));
        this.fenceGateBlock((FenceGateBlock)ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get("copper_raw"), this.blockTexture(Blocks.f_152599_));
    }
}

