/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.providers.language_providers.book;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.datagen.BookLangHelper;
import java.util.HashMap;
import net.rudahee.metallics_arts.data.enums.implementations.MetalTagEnum;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.allomancy.Interactions;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.feruchemic.Tap;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.multi_craft.MultiCaftDescriptions;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.multi_craft.MultiCraftData;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.sub_division.SubdivisionData;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.sub_division.SubdivisionDescription;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.weapons.WeaponDescriptions;
import net.rudahee.metallics_arts.data.enums.implementations.languages.book.weapons.WeaponsData;
import net.rudahee.metallics_arts.data.enums.implementations.languages.old.CTW;

public class BookHelperES {
    public static HashMap<String, String> addDemoBook() {
        HashMap<String, String> bookLangHelper = new HashMap<String, String>();
        BookLangHelper helper = ModonomiconAPI.get().getLangHelper("metallics_arts");
        helper.book("metallics_arts_book");
        bookLangHelper.put(helper.bookName(), CTW.METALLICS_ARTS.getNameInSpanish() + ": " + CTW.GUIDE.getNameInSpanish());
        bookLangHelper.put(helper.bookTooltip(), CTW.BOOK_TOOLTIP.getNameInSpanish());
        bookLangHelper.putAll(BookHelperES.addAllomancyCategory(helper));
        bookLangHelper.putAll(BookHelperES.feruchemyCategory(helper));
        bookLangHelper.putAll(BookHelperES.addIntroCategory(helper));
        return bookLangHelper;
    }

    private static HashMap<String, String> addIntroCategory(BookLangHelper helper) {
        HashMap<String, String> introTraslationsMap = new HashMap<String, String>();
        helper.category("intro");
        introTraslationsMap.put(helper.categoryName(), CTW.INTRODUCTION.getNameInSpanish());
        introTraslationsMap.putAll(BookHelperES.addWelcomeEntry(helper, SubdivisionData.WELCOME));
        for (SubdivisionData subdivisionData : SubdivisionData.values()) {
            if (subdivisionData.isAllomantic() || subdivisionData.isFeruchemical() || subdivisionData.isWelcome()) continue;
            introTraslationsMap.putAll(BookHelperES.addSubDivisionEntry(helper, subdivisionData));
        }
        for (Enum enum_ : WeaponsData.values()) {
            introTraslationsMap.putAll(BookHelperES.addWeaponsEntry(helper, (WeaponsData)enum_));
        }
        for (Enum enum_ : MultiCraftData.values()) {
            introTraslationsMap.putAll(BookHelperES.addMultiCraftEntry(helper, (MultiCraftData)enum_));
        }
        return introTraslationsMap;
    }

    private static HashMap<String, String> addAllomancyCategory(BookLangHelper helper) {
        HashMap<String, String> allomancyTraslationsMap = new HashMap<String, String>();
        helper.category("allomancy");
        allomancyTraslationsMap.put(helper.categoryName(), CTW.ALLOMANCY.getNameInSpanish());
        allomancyTraslationsMap.putAll(BookHelperES.addWelcomeEntry(helper, SubdivisionData.ALLOMANCY));
        for (SubdivisionData subdivisionData : SubdivisionData.values()) {
            if (!subdivisionData.isAllomantic()) continue;
            allomancyTraslationsMap.putAll(BookHelperES.addSubDivisionEntry(helper, subdivisionData));
        }
        for (Enum enum_ : MetalTagEnum.values()) {
            allomancyTraslationsMap.putAll(BookHelperES.addAllomancyEntry(helper, (MetalTagEnum)enum_));
        }
        return allomancyTraslationsMap;
    }

    private static HashMap<String, String> feruchemyCategory(BookLangHelper helper) {
        HashMap<String, String> feruchemyTraslationsMap = new HashMap<String, String>();
        helper.category("feruchemy");
        feruchemyTraslationsMap.put(helper.categoryName(), CTW.FERUCHEMY.getNameInSpanish());
        feruchemyTraslationsMap.putAll(BookHelperES.addWelcomeEntry(helper, SubdivisionData.FERUCHEMY));
        for (SubdivisionData subdivisionData : SubdivisionData.values()) {
            if (!subdivisionData.isFeruchemical()) continue;
            feruchemyTraslationsMap.putAll(BookHelperES.addSubDivisionEntry(helper, subdivisionData));
        }
        for (Enum enum_ : MetalTagEnum.values()) {
            feruchemyTraslationsMap.putAll(BookHelperES.addFeruchemyEntry(helper, (MetalTagEnum)enum_));
        }
        return feruchemyTraslationsMap;
    }

    private static HashMap<String, String> addWelcomeEntry(BookLangHelper helper, SubdivisionData subdivisionEntry) {
        HashMap<String, String> welcomeTraslationsMap = new HashMap<String, String>();
        helper.entry(subdivisionEntry.getId() + "_entry");
        welcomeTraslationsMap.put(helper.entryName(), CTW.valueOf(subdivisionEntry.name()).getNameInSpanish());
        welcomeTraslationsMap.put(helper.entryDescription(), "");
        int x = 1;
        for (String content : SubdivisionDescription.valueOf(subdivisionEntry.name()).getSpanish()) {
            helper.page("page" + x);
            if (x == 1) {
                welcomeTraslationsMap.put(helper.pageTitle(), CTW.valueOf(subdivisionEntry.name()).getNameInSpanish());
            } else {
                welcomeTraslationsMap.put(helper.pageTitle(), "-");
            }
            welcomeTraslationsMap.put(helper.pageText(), content);
            ++x;
        }
        return welcomeTraslationsMap;
    }

    private static HashMap<String, String> addSubDivisionEntry(BookLangHelper helper, SubdivisionData subdivisionEntry) {
        HashMap<String, String> subDivisionTraslationsMap = new HashMap<String, String>();
        helper.entry(subdivisionEntry.getId() + "_entry");
        subDivisionTraslationsMap.put(helper.entryName(), CTW.valueOf(subdivisionEntry.name()).getNameInSpanish());
        subDivisionTraslationsMap.put(helper.entryDescription(), "");
        int x = 1;
        for (String content : SubdivisionDescription.valueOf(subdivisionEntry.name()).getSpanish()) {
            helper.page("page" + x);
            if (x == 1) {
                subDivisionTraslationsMap.put(helper.pageTitle(), CTW.valueOf(subdivisionEntry.name()).getNameInSpanish());
            } else {
                subDivisionTraslationsMap.put(helper.pageTitle(), "-");
            }
            subDivisionTraslationsMap.put(helper.pageText(), content);
            ++x;
        }
        return subDivisionTraslationsMap;
    }

    private static HashMap<String, String> addWeaponsEntry(BookLangHelper helper, WeaponsData weaponsEntry) {
        HashMap<String, String> weaponsTraslationsMap = new HashMap<String, String>();
        helper.entry(weaponsEntry.getId() + "_entry");
        weaponsTraslationsMap.put(helper.entryName(), CTW.valueOf(weaponsEntry.name()).getNameInSpanish());
        weaponsTraslationsMap.put(helper.entryDescription(), "");
        helper.page("weapon_description");
        weaponsTraslationsMap.put(helper.pageTitle(), CTW.valueOf(weaponsEntry.name()).getNameInSpanish());
        weaponsTraslationsMap.put(helper.pageText(), WeaponDescriptions.valueOf(weaponsEntry.name()).getSpanish());
        return weaponsTraslationsMap;
    }

    private static HashMap<String, String> addMultiCraftEntry(BookLangHelper helper, MultiCraftData multiCraftData) {
        HashMap<String, String> multiCraftTraslationsMap = new HashMap<String, String>();
        helper.entry(multiCraftData.getId() + "_entry");
        multiCraftTraslationsMap.put(helper.entryName(), CTW.valueOf(multiCraftData.name()).getNameInSpanish());
        multiCraftTraslationsMap.put(helper.entryDescription(), "");
        helper.page("items_description");
        multiCraftTraslationsMap.put(helper.pageTitle(), CTW.valueOf(multiCraftData.name()).getNameInSpanish());
        multiCraftTraslationsMap.put(helper.pageText(), MultiCaftDescriptions.valueOf(multiCraftData.name()).getSpanish());
        return multiCraftTraslationsMap;
    }

    private static HashMap<String, String> addAllomancyEntry(BookLangHelper helper, MetalTagEnum metal) {
        HashMap<String, String> allomancyTraslationsMap = new HashMap<String, String>();
        helper.entry(metal.getNameLower() + "_entry");
        helper.page("power_description");
        helper.page("power_interactions");
        allomancyTraslationsMap.put(helper.pageTitle(), CTW.INTERACTIONS.getNameInSpanish());
        allomancyTraslationsMap.put(helper.pageText(), Interactions.valueOf(metal.name()).getSpanish());
        return allomancyTraslationsMap;
    }

    private static HashMap<String, String> addFeruchemyEntry(BookLangHelper helper, MetalTagEnum metal) {
        HashMap<String, String> feruchemyTraslationsMap = new HashMap<String, String>();
        helper.entry(metal.getNameLower() + "_entry");
        helper.page("power_tap");
        feruchemyTraslationsMap.put(helper.pageTitle(), "-");
        feruchemyTraslationsMap.put(helper.pageText(), Tap.valueOf(metal.name()).getSpanish());
        return feruchemyTraslationsMap;
    }
}

