/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.data.providers.tags_providers;

import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.rudahee.metallics_arts.data.enums.implementations.languages.old.MetalAuxiliaryInfo;
import net.rudahee.metallics_arts.setup.registries.ModBlocksRegister;
import net.rudahee.metallics_arts.setup.registries.items.ModTags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ModBlockTagProvider
extends BlockTagsProvider {
    @Generated
    private static final Logger log = LogManager.getLogger(ModBlockTagProvider.class);

    public ModBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "metallics_arts", existingFileHelper);
    }

    public CompletableFuture<TagsProvider.TagLookup<Block>> m_274426_() {
        return super.m_274426_();
    }

    protected void m_6577_(HolderLookup.Provider provider) {
        for (MetalAuxiliaryInfo metal : MetalAuxiliaryInfo.values()) {
            if (metal.isVanilla()) {
                this.addVanillaBlocksTags(metal.getId());
                continue;
            }
            if (metal.isAppearsInDeepslate() && metal.isAppearsInStone()) {
                this.addTagsStoneAndDeepslate(metal.getId());
            } else if (metal.isAppearsInDeepslate()) {
                this.addDeepslateTags(metal.getId());
            } else if (metal.isAppearsInStone()) {
                this.addStoneTags(metal.getId());
            }
            if (metal.isAppearsInDeepslate() || metal.isAppearsInStone()) {
                this.addRawTags(metal.getId());
            }
            this.addBasicBlocksTags(metal.getId(), metal.isDivine());
        }
        for (String key : ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.keySet()) {
            this.addForgeTag("storage_blocks/" + key + "_cristal", ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.get(key));
            this.makePickaxeMineable(ModBlocksRegister.DIVINE_CRISTAL_BLOCKS.get(key));
            this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_cristal")});
        }
        for (Block wall : ModBlocksRegister.BLOCK_METAL_WALL.values()) {
            this.m_206424_(BlockTags.f_13032_).m_255245_((Object)wall);
        }
        for (Block fence : ModBlocksRegister.BLOCK_METAL_FENCE.values()) {
            this.m_206424_(BlockTags.f_13039_).m_255245_((Object)fence);
        }
        for (Block fence_gate : ModBlocksRegister.BLOCK_METAL_FENCE_GATE.values()) {
            this.m_206424_(BlockTags.f_13055_).m_255245_((Object)fence_gate);
        }
        this.makePickaxeMineable((Block)ModBlocksRegister.CRUCIBLE_FURNACE.get());
        this.makePickaxeDiamondMineable((Block)ModBlocksRegister.HEMALURGY_ALTAR_BACK.get());
        this.makePickaxeDiamondMineable((Block)ModBlocksRegister.HEMALURGY_ALTAR_FRONT.get());
    }

    private void addTagsStoneAndDeepslate(String key) {
        this.addForgeTag("ores/" + key, ModBlocksRegister.BLOCK_METAL_ORES.get(key), ModBlocksRegister.BLOCK_METAL_DEEPSLATE_ORES.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_ORES.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_DEEPSLATE_ORES.get(key));
        this.addForgeTag("ores_in_ground/deepslate", ModBlocksRegister.BLOCK_METAL_DEEPSLATE_ORES.get(key));
        this.addForgeTag("ores_in_ground/stone", ModBlocksRegister.BLOCK_METAL_ORES.get(key));
    }

    private void addStoneTags(String key) {
        this.addForgeTag("ores/" + key, ModBlocksRegister.BLOCK_METAL_ORES.get(key));
        this.addForgeTag("ores_in_ground/stone", ModBlocksRegister.BLOCK_METAL_ORES.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_ORES.get(key));
    }

    private void addDeepslateTags(String key) {
        this.addForgeTag("ores/" + key, ModBlocksRegister.BLOCK_METAL_DEEPSLATE_ORES.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_DEEPSLATE_ORES.get(key));
        this.addForgeTag("ores_in_ground/deepslate", ModBlocksRegister.BLOCK_METAL_DEEPSLATE_ORES.get(key));
    }

    private void addRawTags(String key) {
        this.addForgeTag("storage_blocks/raw_" + key, ModBlocksRegister.RAW_METAL_BLOCKS.get(key));
        this.makePickaxeMineable(ModBlocksRegister.RAW_METAL_BLOCKS.get(key));
        this.addForgeTagDecoration(key + "_raw");
        this.pickaxeMineableDecoration(key + "_raw");
        this.addGenericForgeTagDecoration(key + "_raw");
        this.m_206424_(ModTags.forgeBlockTag("ores")).addTags(new TagKey[]{ModTags.forgeBlockTag("ores/" + key)});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/raw_" + key)});
    }

    private void addBasicBlocksTags(String key, boolean isDivine) {
        if (isDivine) {
            this.addForgeTag("storage_blocks/" + key, ModBlocksRegister.BLOCK_GEMS_BLOCKS.get(key));
            this.makePickaxeMineable(ModBlocksRegister.BLOCK_GEMS_BLOCKS.get(key));
        } else {
            this.addForgeTag("storage_blocks/" + key, ModBlocksRegister.BLOCK_METAL_BLOCKS.get(key));
            this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_BLOCKS.get(key));
        }
        this.addForgeTagDecoration(key);
        this.addGenericForgeTagDecoration(key);
        this.pickaxeMineableDecoration(key);
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key)});
    }

    public void addForgeTagDecoration(String key) {
        this.addForgeTag("storage_blocks/" + key + "_stairs", ModBlocksRegister.BLOCK_METAL_STAIRS.get(key));
        this.addForgeTag("storage_blocks/" + key + "_slab", ModBlocksRegister.BLOCK_METAL_SLAB.get(key));
        this.addForgeTag("storage_blocks/" + key + "_wall", ModBlocksRegister.BLOCK_METAL_WALL.get(key));
        this.addForgeTag("storage_blocks/" + key + "_fence", ModBlocksRegister.BLOCK_METAL_FENCE.get(key));
        this.addForgeTag("storage_blocks/" + key + "_fence_gate", ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(key));
    }

    public void addGenericForgeTagDecoration(String key) {
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_stairs")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_slab")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_wall")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_fence")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_fence_gate")});
    }

    private void pickaxeMineableDecoration(String key) {
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_STAIRS.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_SLAB.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_WALL.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_FENCE.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(key));
    }

    private void addVanillaBlocksTags(String key) {
        this.addForgeTag("storage_blocks/" + key + "_wall", ModBlocksRegister.BLOCK_METAL_WALL.get(key));
        this.addForgeTag("storage_blocks/" + key + "_fence", ModBlocksRegister.BLOCK_METAL_FENCE.get(key));
        this.addForgeTag("storage_blocks/" + key + "_fence_gate", ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(key));
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_wall")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_fence")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_fence_gate")});
        this.addForgeTag("storage_blocks/" + key + "_raw_wall", ModBlocksRegister.BLOCK_METAL_WALL.get(key + "_raw"));
        this.addForgeTag("storage_blocks/" + key + "_raw_fence", ModBlocksRegister.BLOCK_METAL_FENCE.get(key + "_raw"));
        this.addForgeTag("storage_blocks/" + key + "_raw_fence_gate", ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(key + "_raw"));
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_raw_wall")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_raw_fence")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_raw_fence_gate")});
        this.addForgeTag("storage_blocks/" + key + "_raw_stairs", ModBlocksRegister.BLOCK_METAL_STAIRS.get(key + "_raw"));
        this.addForgeTag("storage_blocks/" + key + "_raw_slab", ModBlocksRegister.BLOCK_METAL_SLAB.get(key + "_raw"));
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_raw_stairs")});
        this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_raw_slab")});
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_WALL.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_FENCE.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(key));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_WALL.get(key + "_raw"));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_FENCE.get(key + "_raw"));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_FENCE_GATE.get(key + "_raw"));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_STAIRS.get(key + "_raw"));
        this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_SLAB.get(key + "_raw"));
        if (!key.equals("copper")) {
            this.addForgeTag("storage_blocks/" + key + "_stairs", ModBlocksRegister.BLOCK_METAL_STAIRS.get(key));
            this.addForgeTag("storage_blocks/" + key + "_slab", ModBlocksRegister.BLOCK_METAL_SLAB.get(key));
            this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_stairs")});
            this.m_206424_(ModTags.forgeBlockTag("storage_blocks")).addTags(new TagKey[]{ModTags.forgeBlockTag("storage_blocks/" + key + "_slab")});
            this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_STAIRS.get(key));
            this.makePickaxeMineable(ModBlocksRegister.BLOCK_METAL_SLAB.get(key));
        }
    }

    private void addForgeTag(String name, Block ... items) {
        log.debug("Creating block tag for forge:" + name);
        this.m_206424_(BlockTags.create((ResourceLocation)new ResourceLocation("forge", name))).replace(false).m_255179_((Object[])items);
    }

    private void makePickaxeMineable(Block ... items) {
        this.addTag("mineable/pickaxe", items);
        this.addTag("needs_iron_tool", items);
    }

    private void makePickaxeDiamondMineable(Block ... items) {
        this.addTag("mineable/pickaxe", items);
        this.addTag("needs_iron_tool", items);
    }

    private void addTag(String name, Block ... items) {
        log.debug("Creating block tag for minecraft:" + name);
        this.m_206424_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", name))).replace(false).m_255179_((Object[])items);
    }

    public String m_6055_() {
        return "Metallic Arts Block Tags";
    }
}

