/*
 * Decompiled with CFR 0.152.
 */
package net.rudahee.metallics_arts.modules.custom_block_entities.crucible_furnace;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.rudahee.metallics_arts.data.custom_recipes.tables.CrucibleFurnaceRecipe;
import net.rudahee.metallics_arts.modules.custom_block_entities.crucible_furnace.CrucibleFurnaceMenu;
import net.rudahee.metallics_arts.setup.registries.ModBlockEntitiesRegister;
import net.rudahee.metallics_arts.setup.registries.ModItemsRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucibleFurnaceBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            CrucibleFurnaceBlockEntity.this.m_6596_();
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            switch (slot) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return Items.f_42416_ == stack.m_41720_() || Items.f_42417_ == stack.m_41720_() || Items.f_151052_ == stack.m_41720_() || Items.f_42413_ == stack.m_41720_() || ModItemsRegister.ITEM_METAL_INGOT.values().stream().anyMatch(m -> m == stack.m_41720_()) || ModItemsRegister.ITEM_GEMS_BASE.values().stream().anyMatch(m -> m == stack.m_41720_());
                }
                case 0: {
                    return Items.f_42448_ == stack.m_41720_();
                }
                case 6: {
                    return true;
                }
            }
            return false;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CrucibleFurnaceBlockEntity.this.progress;
                case 1 -> CrucibleFurnaceBlockEntity.this.maxProgress;
                case 2 -> CrucibleFurnaceBlockEntity.this.fuelStorage;
                case 3 -> CrucibleFurnaceBlockEntity.this.maxFuelStorage;
                case 4 -> CrucibleFurnaceBlockEntity.this.timeWithoutRecipe;
                case 5 -> CrucibleFurnaceBlockEntity.this.tickFuel;
                case 6 -> CrucibleFurnaceBlockEntity.this.tickProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CrucibleFurnaceBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    CrucibleFurnaceBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    CrucibleFurnaceBlockEntity.this.fuelStorage = value;
                    break;
                }
                case 3: {
                    CrucibleFurnaceBlockEntity.this.maxFuelStorage = value;
                    break;
                }
                case 4: {
                    CrucibleFurnaceBlockEntity.this.timeWithoutRecipe = value;
                    break;
                }
                case 5: {
                    CrucibleFurnaceBlockEntity.this.tickFuel = value;
                    break;
                }
                case 6: {
                    CrucibleFurnaceBlockEntity.this.tickProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private int fuelStorage = 0;
    private int maxFuelStorage = 100;
    private int timeWithoutRecipe = 0;
    private int tickFuel = 0;
    private int tickProgress = 0;
    private int tickAnim = 0;
    public static final int PROGRESS_INDEX = 0;
    public static final int MAX_PROGRESS_INDEX = 1;
    public static final int FUEL_STORAGE_INDEX = 2;
    public static final int MAX_FUEL_STORAGE_INDEX = 3;
    public static final int TIME_WITHOUT_RECIPE_INDEX = 4;
    public static final int TICK_FUEL_INDEX = 5;
    public static final int TICK_PROGRESS_INDEX = 6;

    public CrucibleFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntitiesRegister.CRUCIBLE_FURNACE_ENTITY.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.metallics_arts.menu.crucible_furnace");
    }

    @Deprecated(since="1.6.5", forRemoval=true)
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("crucible_furnace.progress", this.progress);
        tag.m_128405_("crucible_furnace.max_progress", this.maxProgress);
        tag.m_128405_("crucible_furnace.fuel_storage", this.fuelStorage);
        tag.m_128405_("crucible_furnace.max_fuel_storage", this.maxFuelStorage);
        tag.m_128405_("crucible_furnace.time_without_recipe", this.timeWithoutRecipe);
        tag.m_128405_("crucible_furnace.tick_fuel", this.tickFuel);
        tag.m_128405_("crucible_furnace.tick_progress", this.tickProgress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("crucible_furnace.progress");
        this.maxProgress = tag.m_128451_("crucible_furnace.max_progress");
        this.fuelStorage = tag.m_128451_("crucible_furnace.fuel_storage");
        this.maxFuelStorage = tag.m_128451_("crucible_furnace.max_fuel_storage");
        this.timeWithoutRecipe = tag.m_128451_("crucible_furnace.time_without_recipe");
        this.tickFuel = tag.m_128451_("crucible_furnace.tick_fuel");
        this.tickProgress = tag.m_128451_("crucible_furnace.tick_progress");
        super.m_142466_(tag);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrucibleFurnaceBlockEntity entity) {
        if (!level.m_5776_()) {
            if (entity.itemHandler.getStackInSlot(0).m_150930_(Items.f_42448_)) {
                if (entity.data.m_6413_(2) < entity.data.m_6413_(3)) {
                    CrucibleFurnaceBlockEntity.rechargeFuel(entity, level, pos, state);
                }
            }
            if (CrucibleFurnaceBlockEntity.hasRecipe(entity)) {
                CrucibleFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                CrucibleFurnaceBlockEntity.craftItem(entity);
            } else if (entity.fuelStorage > 0) {
                ++entity.timeWithoutRecipe;
                if (entity.timeWithoutRecipe >= 20000) {
                    if (entity.itemHandler.getStackInSlot(5).m_150930_(Items.f_41852_)) {
                        entity.itemHandler.setStackInSlot(5, new ItemStack((ItemLike)Items.f_41999_, (int)Math.ceil((double)entity.fuelStorage / 100.0 * 10.0)));
                        entity.timeWithoutRecipe = 0;
                        entity.fuelStorage = 0;
                    } else {
                        --entity.timeWithoutRecipe;
                        --entity.fuelStorage;
                    }
                }
                entity.resetProgress();
                CrucibleFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
            if (level instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)level;
                if (entity.fuelStorage > 0) {
                    clientLevel.m_8055_(pos).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true));
                }
            }
            if (level instanceof ServerLevel) {
                ServerLevel servLevel = (ServerLevel)level;
                if (entity.fuelStorage > 0) {
                    if (entity.tickAnim == 5) {
                        servLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 3, 0.0, 0.0, 0.0, 0.0);
                        servLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0, 0.0, 0.5, 0.5, 0.0);
                        entity.tickAnim = 0;
                    } else {
                        ++entity.tickAnim;
                    }
                }
            }
        }
    }

    public static void rechargeFuel(CrucibleFurnaceBlockEntity entity, Level level, BlockPos pos, BlockState state) {
        if (entity.fuelStorage >= 80) {
            entity.fuelStorage = entity.maxFuelStorage;
            CrucibleFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        } else {
            entity.fuelStorage += 20;
            CrucibleFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        entity.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_));
    }

    private void resetProgress() {
        this.tickProgress = 0;
        this.tickFuel = 0;
        this.progress = 0;
    }

    private static void craftItem(CrucibleFurnaceBlockEntity entity) {
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = entity.f_58857_.m_7465_().m_44015_((RecipeType)CrucibleFurnaceRecipe.Type.INSTANCE, (Container)inventory, entity.f_58857_);
        if (recipe.isPresent() && entity.itemHandler.getStackInSlot(5).m_41613_() < 64 && entity.fuelStorage > 0) {
            if (entity.tickProgress <= 1) {
                ++entity.tickProgress;
            } else {
                ++entity.progress;
                entity.tickProgress = 0;
            }
            if (entity.progress >= entity.maxProgress) {
                entity.itemHandler.extractItem(1, 1, false);
                entity.itemHandler.extractItem(2, 1, false);
                entity.itemHandler.extractItem(3, 1, false);
                entity.itemHandler.extractItem(4, 1, false);
                if (entity.itemHandler.getStackInSlot(5).m_41619_()) {
                    entity.itemHandler.setStackInSlot(5, new ItemStack(((CrucibleFurnaceRecipe)recipe.get()).getResultItem().m_220173_(), 4));
                } else {
                    entity.itemHandler.setStackInSlot(5, new ItemStack((ItemLike)((CrucibleFurnaceRecipe)recipe.get()).getResultItem().m_41720_(), entity.itemHandler.getStackInSlot(5).m_41613_() + 4));
                }
                entity.progress = 0;
            }
            if (entity.tickFuel <= 1000) {
                ++entity.tickFuel;
            } else {
                entity.tickFuel = 0;
                --entity.fuelStorage;
            }
        }
    }

    private static boolean hasRecipe(CrucibleFurnaceBlockEntity entity) {
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = entity.f_58857_.m_7465_().m_44015_((RecipeType)CrucibleFurnaceRecipe.Type.INSTANCE, (Container)inventory, entity.f_58857_);
        return recipe.isPresent();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new CrucibleFurnaceMenu(id, inv, this, this.data);
    }
}

